﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/util/util_Vector.h>

#include "PushMotionDetector.h"
#include "SixAxisSensorGestureProcessor.h"

namespace {

} // namespace

PushMotionDetector::PushMotionDetector() NN_NOEXCEPT
    : m_IsPushStarted(false)
    , m_ThresholdPushDetectAccLengthSquared(9.f) // 4[G^2]
{
    // 何もしない
}

PushMotionDetector::~PushMotionDetector() NN_NOEXCEPT
{
    // 何もしない
}

void PushMotionDetector::Reset() NN_NOEXCEPT
{
    m_Lifo.Clear();
}

void PushMotionDetector::Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT
{
    // NN_LOG("%f, %f, %f\n"
    //     , rawState.acc.GetX()
    //     , rawState.acc.GetY()
    //     , rawState.acc.GetZ()
    // );

    if (rawState.accLengthSquared < m_ThresholdPushDetectAccLengthSquared)
    {
        m_IsPushStarted = false;
        return;
    }

    if (m_IsPushStarted)
    {
        // 2 回目以降は無視
        return;
    }

    m_IsPushStarted = true;

    auto maxAxis = 0;
    auto maxValue = ::std::abs(rawState.acc.GetX());
    auto isPositive = (rawState.acc.GetX() > 0.f);
    if (maxValue < ::std::abs(rawState.acc.GetY()))
    {
        maxAxis = 1;
        maxValue = ::std::abs(rawState.acc.GetY());
        isPositive = (rawState.acc.GetY() > 0.f);
    }
    if (maxValue < ::std::abs(rawState.acc.GetZ()))
    {
        maxAxis = 2;
        maxValue = ::std::abs(rawState.acc.GetZ());
        isPositive = (rawState.acc.GetZ() > 0.f);
    }

    auto offset = (isPositive) ? 3 : 0; // デバイスに掛かる力の方向はセンサー値と逆方向
    offset += maxAxis;
    m_Lifo.Append(
        MotionState({
            m_SamplingNumber,
            rawState.samplingNumber,
            static_cast<MotionType>(MotionType_PushPlusX + offset),
        })
    );

    // NN_LOG("%x, %lld, %f, %f\n"
    //     , static_cast<MotionType>(MotionType_PushPlusX + offset)
    //     , rawState.samplingNumber
    //     , rawState.accLengthSquared
    //     , m_ThresholdPushDetectAccLengthSquared);

    m_SamplingNumber++;
}

int PushMotionDetector::GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT
{
    return m_Lifo.Read(pOutStates, count);
}
