﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_Vector.h>

#include "IMotionDetector.h"

class PeakMotionDetector final : public IMotionDetector
{
    NN_DISALLOW_COPY(PeakMotionDetector);
    NN_DISALLOW_MOVE(PeakMotionDetector);

public:

    PeakMotionDetector() NN_NOEXCEPT;

    virtual ~PeakMotionDetector() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Reset() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Update(const SixAxisSensorRawState& rawState) NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetMotions(MotionState* pOutStates, int count) NN_NOEXCEPT NN_OVERRIDE;

private:

    SixAxisSensorRawState m_RawState;

    // モーション検出のための内部ステートです。
    enum State
    {
        State_Detecting, // 検出状態
        State_Stable,    // 検出待ち状態
    };

    State m_State; // 内部ステート

    SixAxisSensorRawState m_SixAxisSensorRawState; // 検出時のセンサー値です。

    float m_ThresholdAccLengthSquared; // 加速度二乗和の閾値です。
    int m_IgnoreDeltaSampleCount;      // チャタリング回避のためこのサンプル数分は無視します。
};
