﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommon.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_NpadJoyLeft.h>

#include "JoyLeftSixAxisSensor.h"

JoyLeftSixAxisSensor::JoyLeftSixAxisSensor(const nn::hid::NpadIdType& id) NN_NOEXCEPT
    : INpadStyleSixAxisSensor(id, nn::hid::NpadStyleJoyLeft::Mask)
{
}

void JoyLeftSixAxisSensor::Update() NN_NOEXCEPT
{
    // ボタンの状態を更新します
    m_Buttons[1] = m_Buttons[0];
    nn::hid::NpadJoyLeftState state;
    nn::hid::GetNpadState(&state, m_Id);
    m_Buttons[0] = state.buttons;

    // 6 軸センサーの状態を更新します
    UpdateSixAxisSensor();
}

bool JoyLeftSixAxisSensor::IsConnected() const NN_NOEXCEPT
{
    //現在有効な操作形態(NpadStyleSet)を取得
    nn::hid::NpadStyleSet style = nn::hid::GetNpadStyleSet(m_Id);

    return style.Test<nn::hid::NpadStyleJoyLeft>();
}
