﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/ldn.h>

#include <nn/hid.h>

#include "GraphicsSystem.h"
#include "FontSystem.h"
#include "Color.h"
#include "Npad.h"
#include "ApplicationHeap.h"
#include "Gesture.h"

namespace frm {

    static const char* LdnFunctionText[] =
    {
        "Create Network",
        "Destroy Network",
        "Open Station",
        "Close Station",
    };
    const int LdnFunctionTextSize = NN_ARRAY_SIZE(LdnFunctionText);

    struct LocalCommDrawPosition
    {
        float         X = 1280.f;
        const float   Y = 550.f;
        const float   Width = 300.f;
        const float   Height = 160.f;
    };

    struct LdnCursol
    {
        bool    up      = false;
        bool    down    = false;
        bool    left    = false;
        bool    right   = false;
        bool    fix     = false;
        bool    cancel  = false;
    };

    struct LdnConfig
    {
        nn::ldn::NetworkConfig      network;
        nn::ldn::SecurityConfig     security;
        nn::ldn::UserConfig         user;
        nn::ldn::ScanFilter         filter;
    };

    struct LdnInfo
    {
        nn::ldn::NetworkInfo*       info;
        int                         count;
    };

    //!< LocalCommunication 向けの処理を記述したクラスです。
    class LocalCommunication
    {
    private:
        int     m_topMenu = 0;
        int     m_connectCount = 1;
        int     m_function = 0;
        int     m_getStateCount = 0;

        LdnCursol m_cursol;

        uint8_t m_TwinkleCounter = 0;
        bool m_TwinkleSwitchFlag = false;

        int m_SwipeCounter         = 0;
        int m_SwipeCounterState    = 0;
        float m_DeltaX            = 0.f;

        LocalCommDrawPosition       m_DrawPotition;

        LdnInfo                     m_Info;
        LdnConfig                   m_Config;

        const char* ToString(nn::Result result);
        const char* ToString(nn::ldn::State state);
        void UpdateTwinkleCounter();
        void UpdateSwipeCounter(int functionMenu);

        void StartNetwork(void);
        void Configuration(void);
        void Scaning(void);
        void Connection(void);
        void GetInfo(void);
        void CreateNetwork(void);
        void DestroyNetwork(void);

        void CloseStation(void);

        void OpenStation(void);

    public:
        static LocalCommunication& GetInstance() NN_NOEXCEPT;

        void Control(frm::NpadState* npadState);

        void Draw(GraphicsSystem * pGraphicsSystem, nn::gfx::util::DebugFontTextWriter * pTextWriter, int functionMenu);
    };
}

#ifndef gLdn
#define gLdn (frm::LocalCommunication::GetInstance())
#endif
