﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "IrSensor.h"

namespace frm {

    /* ------------------------------------------------------------ */
    // PUBLIC関数
    /* ------------------------------------------------------------ */
    IrSensor& IrSensor::GetInstance()
    {
        static IrSensor Instance;
        return Instance;
    }

    void IrSensor::Initialize(int index) NN_NOEXCEPT
    {
        if (m_Info[index].isInitialized == false)
        {
            m_Info[index].handle = nn::irsensor::GetIrCameraHandle(gNpad.ConvertNpadIdFromIndex(index));
            nn::irsensor::Initialize(m_Info[index].handle);
            m_Info[index].isInitialized = true;
        }
    }

    void IrSensor::Finalize(int index)
    {
       if (m_Info[index].isInitialized == true)
       {
            nn::irsensor::Finalize(m_Info[index].handle);
            m_Info[index].isInitialized = false;
            m_Info[index].isRunning = false;
        }
    }

    void IrSensor::SwitchStartAndStop(int index)
    {
        if (m_Info[index].isRunning)
        {
            Stop(index);
        }
        else
        {
            Start(index);
        }
    }

    void IrSensor::Start(int index)
    {
        if (m_Info[index].isInitialized)
        {
            nn::irsensor::GetMomentProcessorDefaultConfig(&m_Info[index].config);
            nn::irsensor::RunMomentProcessor(m_Info[index].handle, m_Info[index].config);
            m_Info[index].isRunning = true;
        }

    }

    void IrSensor::Stop(int index)
    {
        if (m_Info[index].isInitialized)
        {
            nn::irsensor::StopImageProcessorAsync(m_Info[index].handle);
            m_Info[index].isRunning = false;
        }
    }
}
