﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
* @brief
*  nn::hid ライブラリのジェスチャ API の使い方を示すサンプルプログラム
*/

#pragma once

#include <cstdlib>
#include <list>
#include <vector>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nn/hid/hid_Gesture.h>
#include <nn/TargetConfigs/build_Platform.h>
#include <nn/util/util_Constant.h>
#include <nn/util/util_MathTypes.h>
#include <nn/util/util_Matrix.h>

#if defined(NN_BUILD_TARGET_PLATFORM_NX)
#include <nv/nv_MemoryManagement.h>
#endif

#include "ApplicationHeap.h"
#include "GraphicsSystem.h"
#include "FontSystem.h"
#include "Color.h"

namespace frm{

    struct PanState
    {
        bool                            IsPan;      //!< Panがあったかどうか
        int32_t                         x;          //!< Panの x 座標です。
        int32_t                         y;          //!< Panの y 座標です。
        int32_t                         deltaX;     //!< Panの x 座標の移動差分です。
        int32_t                         deltaY;     //!< Panの y 座標の移動差分です。
    };

    struct SwipeState
    {
        bool                            IsSwipe;      //!< Swipeがあったかどうか
        nn::hid::GestureDirection       Direction;    //!< Swipeの方向です。
        int32_t                         x;            //!< Swipeの x 座標です。
        int32_t                         y;            //!< Swipeの y 座標です
    };

    struct GestureState
    {
        bool                            IsUpdate[nn::hid::GestureStateCountMax];      //!< ジェスチャの状態が更新されたかどうかを表すフラグです。
        nn::hid::GestureState           Data[nn::hid::GestureStateCountMax];          //!< ジェスチャの状態です。
        nn::hid::GestureType            Type[nn::hid::GestureStateCountMax];          //!< ジェスチャの種類です。
        nn::hid::GestureDirection       Direction[nn::hid::GestureStateCountMax];     //!< ジェスチャの方向です。
        int                             Count;                                        //!< 更新のあったデータの数です。
        bool                            TouchTrigger;                                 //!< ジェスチャの種類=Touchの場合のトリガ入力です。
    };

    class Gesture
    {
    private:
        int64_t m_EventNumberPrev;

        GestureState m_State;

        void WriteCursor(nn::gfx::util::DebugFontTextWriter* pTextWriter, int32_t x, int32_t y) NN_NOEXCEPT;

        bool GetTouchTrigger(GestureState * state) NN_NOEXCEPT;

    public:
        static Gesture& GetInstance() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;

        const char* ToString(nn::hid::GestureDirection direction) NN_NOEXCEPT;

        const char* ToString(nn::hid::GestureType type) NN_NOEXCEPT;

        PanState GetPan(void) NN_NOEXCEPT;

        SwipeState GetSwipe(void) NN_NOEXCEPT;

        bool MakeButton(nn::gfx::util::DebugFontTextWriter * pTextWriter, GraphicsSystem * pGraphicsSystem, const char * title, float x, float y) NN_NOEXCEPT;

        bool GetTouchTriggerInRange(float x, float y, float width, float height) NN_NOEXCEPT;

        bool UpdateState(GestureState * state);

        GestureState GetState(void) NN_NOEXCEPT;

        void WritePoints(nn::gfx::util::DebugFontTextWriter * pTextWriter, const GestureState state) NN_NOEXCEPT;
    };

}

#ifndef gGesture
#define gGesture (frm::Gesture::GetInstance())
#endif
