﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <nn/swkbd/swkbd_Api.h>

#include "ApplicationHeap.h"

namespace frm{

    struct Mount
    {
        bool            isMounted;      // Mount済かどうか
        std::string     type;           // Mount種別("PC","SD"とか)
        std::string     divChar;        // ドライブ名の区切り(":/",":\"とか)
        std::string     rootPath;       // Rootのパス("C://hoge/hogehoge/・・・"とか)
        std::string     driveName;      // ドライブ名("C:/","D:/"とか)
        std::string     path;           // ドライブ名を省いたRootのパス("/hoge/hogehoge/・・・"とか)
    };

    class Fs
    {
    private:
        static const size_t         MaxEntryCount = 100;

    public:
        Mount                       m_mount;

        char*                                    m_pRomCacheBuffer;
        NN_ALIGNAS(nn::os::MemoryPageSize) char  m_WorkBuffer[32 * 1024];

        //----------------------------------------------------------------
        // @brief   インスタンス取得
        //----------------------------------------------------------------
        static Fs& GetInstance(void) NN_NOEXCEPT;

        void Initialize(void);

        const char* ToString(nn::Result result);

        void MountHost(std::string rootpath);

        void MountSd(std::string rootpath);

        void Unmount(void);

        void LoadFileRootPath(void);

        void LoadFile(std::string * outputStr, int * outputFileCount, std::string pathStr);
    };
}

#ifndef gFs
#define gFs (frm::Fs::GetInstance())
#endif
