﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ExecuteFunction.h"

namespace util{

    /* ------------------------------------------------------------ */
    // クラス外関数
    /* ------------------------------------------------------------ */


    /* ------------------------------------------------------------ */
    // Class ExcuteFunction
    /* ------------------------------------------------------------ */
    /* ------------------------------------------------------------ */
    // PUBLIC関数
    /* ------------------------------------------------------------ */
    ExcuteFunction& ExcuteFunction::GetInstance()
    {
        static ExcuteFunction Instance;
        return Instance;
    }

    void ExcuteFunction::Do(frm::CursolPosition cursol)
    {
        if (cursol.CursolStatus == frm::CursolStatus_DoNpadFunction)
        {
            // ActivityをファイルからPalmaに書き込む処理
            switch (cursol.writeFunctionFixed)
            {
                case frm::ActivityFunctionSelect_ActivityFilePathSelect:
                    gFs.LoadFileRootPath();
                    gFs.LoadFile(gPalma.m_ActivityFile.wave, &gPalma.m_ActivityFile.waveCount, "/Wave/");
                    gFs.LoadFile(gPalma.m_ActivityFile.rgbLed, &gPalma.m_ActivityFile.rgbLedCount, "/RgbLed/");
                    gFs.LoadFile(gPalma.m_Appdata.data, &gPalma.m_Appdata.count, "/ApplicationData/");
                    break;

                case frm::ActivityFunctionSelect_WriteSound:
                    gPalma.WriteWave(cursol.sound, cursol.writeElement.npadIndex, cursol.writeElement, cursol.writeElement.Entry.waveIndex);
                    break;

                case frm::ActivityFunctionSelect_LoadFile:
                    gFs.LoadFile(gPalma.m_ActivityFile.wave, &gPalma.m_ActivityFile.waveCount, "/Wave/");
                    gFs.LoadFile(gPalma.m_ActivityFile.rgbLed, &gPalma.m_ActivityFile.rgbLedCount, "/RgbLed/");
                    gFs.LoadFile(gPalma.m_Appdata.data, &gPalma.m_Appdata.count, "/ApplicationData/");
                    break;

                case frm::ActivityFunctionSelect_WriteRgbLed:
                    gPalma.WriteRgbLed(cursol.rgbLed, cursol.writeElement.npadIndex, cursol.writeElement, cursol.writeElement.Entry.rgbLedPatternIndex);;
                    break;

                case frm::ActivityFunctionSelect_NoOperate:
                    // do nothing
                    break;

                default:
                    break;
            }
            // Npad毎に実施する処理
            for (auto index = 0; index < frm::NpadIdNum; index++)
            {
                switch (cursol.npadFunctionFixed[index])
                {
                    case frm::NpadFunctionSelect_StartScan:
                        if (cursol.scanDeviseType == 0)
                        {
                            gPalma.StartScan();
                        }
                        else
                        {
                            gBle.StartBleScanSmartDevice();
                        }
                        break;

                    case frm::NpadFunctionSelect_StopScan:
                        if (gPalma.m_isScaning)
                        {
                            gPalma.StopScan();
                        }
                        if (gBle.m_IsScanningSmartDevice)
                        {
                            gBle.StopBleScanSmartDevice();
                        }
                        break;

                    case frm::NpadFunctionSelect_SetPairing:
                        gPalma.SetPairing(index);
                        break;

                    case frm::NpadFunctionSelect_ResetPairing:
                        gBle.ResetPairing();
                        break;

                    case frm::NpadFunctionSelect_EnablePairedConnect:
                        gPalma.EnablePairedConnect();
                        break;

                    case frm::NpadFunctionSelect_DisablePairedConnect:
                        gPalma.DisablePairedConnect();
                        break;

                    case frm::NpadFunctionSelect_PlayActivity:
                        gPalma.PlayActivity(index, cursol.activityElement[index]);
                        break;

                    case frm::NpadFunctionSelect_CheckReserved:
                        gPalma.CheckReserved(index, cursol.reservedCheckIndex[index]);
                        break;

                    case frm::NpadFunctionSelect_WriteActivity:
                        gPalma.WriteActivity(index, cursol.activityElement[index]);;
                        break;

                    case frm::NpadFunctionSelect_EnableStep:
                        gPalma.EnableStep(index);
                        break;

                    case frm::NpadFunctionSelect_ReadStep:
                        gPalma.ReadStep(index);
                        break;

                    case frm::NpadFunctionSelect_DisableStep:
                        gPalma.DisableStep(index);
                        break;

                    case frm::NpadFunctionSelect_ResetStep:
                        gPalma.ResetStep(index);
                        break;

                    case frm::NpadFunctionSelect_SetFrModeType:
                        gPalma.SetFrModeType(index, cursol.frMode[index]);
                        break;

                    case frm::NpadFunctionSelect_SuspendFeatureSet:
                        gPalma.SuspendFeatureSet(index, cursol.featureSet[index]);
                        break;

                    case frm::NpadFunctionSelect_ReadUniqueCode:
                        gPalma.ReadUniqueCode(index);
                        break;

                    case frm::NpadFunctionSelect_DiableUniqueCode:
                        gPalma.DisableUniqueCode(index);
                        break;

                    case frm::NpadFunctionSelect_ReadPlayLog:
                        gPalma.ReadPlayLog(index, cursol.playLogIndex[index]);
                        break;

                    case frm::NpadFunctionSelect_ResetPlayLog:
                        gPalma.ResetPlayLog(index, cursol.playLogIndex[index]);
                        break;

                    case frm::NpadFunctionSelect_ReadAppSection:
                        gPalma.ReadPalmaApplicationSection(index, cursol.appSection[index]);
                        break;

                    case frm::NpadFunctionSelect_WriteAppSection:
                        gPalma.WritePalmaApplicationSection(index, cursol.appSection[index]);
                        break;

                    case frm::NpadFunctionSelect_GetDataBaseIdVer:
                        gPalma.GetDataBaseIdVer(index);
                        break;

                    case frm::NpadFunctionSelect_WriteDataBaseIdVer:
                        gPalma.SetDataBaseIdVer(index, cursol.dataBaseIdVer[index]);
                        break;

                    case frm::NpadFunctionSelect_SetBoostMode:
                        gPalma.SetBoostMode(cursol.isBoostMode[index]);
                        break;

                    case frm::NpadFunctionSelect_PlayIrSensor:
                        gIrSensor.SwitchStartAndStop(index);
                        break;

                    case frm::NpadFunctionSelect_PlayVibration:

                        break;

                    case frm::NpadFunctionSelect_NoOperate:
                        // do nothing
                        break;

                    default:
                        break;
                }
            }
        }
    } // NOLINT(impl/function_size)
}
