﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../Simple2D_Types.h"

//#define S2D_ENABLE_DEBUG_LOG

namespace s2d { namespace detail {

// 経過時間を表示
NN_FORCEINLINE
void PrintDiffTime(const char* caption, nn::os::Tick startTick) NN_NOEXCEPT
{
#if defined(S2D_ENABLE_DEBUG_LOG)
    NN_ASSERT_NOT_NULL(caption);

    auto diff = (nn::os::GetSystemTick() - startTick).ToTimeSpan();
    NN_LOG(
        "%s: %02d.%03d.%03d\n",
        caption,
        diff.GetSeconds(),
        diff.GetMilliSeconds() % 1000,
        diff.GetMicroSeconds() % 1000);
#else
    NN_UNUSED(caption);
    NN_UNUSED(startTick);
#endif  // if defined(S2D_ENABLE_DEBUG_LOG)
}

// 2^n の値に切り上げる
int RoundUpPow2(int value) NN_NOEXCEPT;

// ビットマップファイルを読み込み、画像サイズとピクセルデータを取得
ResultCode LoadBitmap(Size* pImageSize, void** ppOutBuffer, const char* filename) NN_NOEXCEPT;

// JPEG ファイルを読み込み、画像サイズとピクセルデータを取得
ResultCode LoadJpeg(Size* pImageSize, void** ppOutBuffer, const char* filename) NN_NOEXCEPT;

}}  // s2d::detail
