﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>

#include "s2d/Simple2D.h"


class IVectorChartDataSetAccessor
{
public:
    struct VectorType
    {
        float x;
        float y;
        float length;
    };

protected:
    std::string m_Label;
    s2d::Color m_Color;

public:
    virtual int size() NN_NOEXCEPT = 0;
    virtual VectorType back() NN_NOEXCEPT = 0;
    virtual VectorType at(int index) NN_NOEXCEPT = 0;
    virtual const char* xStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* yStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* dirStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* lenStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* lenMaxStr(char* buf) NN_NOEXCEPT = 0;
    virtual const char* lenMinStr(char* buf) NN_NOEXCEPT = 0;
    s2d::Color color() NN_NOEXCEPT
    {
        return m_Color;
    }
    const char* label() NN_NOEXCEPT
    {
        return m_Label.c_str();
    }
};

struct VectorChartUiParameterConfig
{
    float init;
    float max;
    float min;
    float step;
};

const int VectorChartUiParametCount = 2;

struct VectorChartUiParameterConfigList
{
    union
    {
        VectorChartUiParameterConfig v[VectorChartUiParametCount];
        struct
        {
            VectorChartUiParameterConfig sampleCount;
            VectorChartUiParameterConfig scale;
        };
    };
};

class VectorChart
{
public:
    enum UiParameterType
    {
        UiParameterType_SampleCount,
        UiParameterType_Scale,
    };

private:
    VectorChartUiParameterConfigList m_UiParameterConfig;
    float        m_UiParameter[VectorChartUiParametCount];
    float        m_Max;             // 表示する最大値
    int          m_SampleCountMax;  // 表示するサンプル数
    bool         m_YInFloat;        // 軸を Float で扱うかどうか

public:
    VectorChart(const VectorChartUiParameterConfigList& config, bool yInFloat) NN_NOEXCEPT;
    void Increment(UiParameterType param) NN_NOEXCEPT;
    void Decrement(UiParameterType param) NN_NOEXCEPT;
    void Draw(s2d::Point2D position,
              float        size,
              std::string  xStr,
              std::string  yStr,
              IVectorChartDataSetAccessor* pDataSets[],
              int count) NN_NOEXCEPT;


private:
    void DrawFrame(s2d::Point2D position,
                   float        size,
                   std::string  xStr,
                   std::string  yStr) NN_NOEXCEPT;
    void DrawSamples(s2d::Point2D position,
                     float        size,
                     IVectorChartDataSetAccessor* pDataSets[],
                     int count) NN_NOEXCEPT;
    void DrawValue(s2d::Point2D position,
                   float        size,
                   IVectorChartDataSetAccessor* pDataSets[],
                   int count) NN_NOEXCEPT;

    void UpdateUiParameter() NN_NOEXCEPT;
};
