﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <array>
#include <cmath>
#include <nn/nn_Assert.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/hid/system/hid_CommonTypes.h>
#include <nn/util/util_Constant.h>

#include "AnalogStickUtil.h"
#include "ControllerCommonTypes.h"
#include "RxPacketMonitor.h"
#include "SixAxisSensorUtil.h"

class UniquePadAccessor
{
    NN_DISALLOW_COPY(UniquePadAccessor);
    NN_DISALLOW_MOVE(UniquePadAccessor);

private:
    nn::hid::system::UniquePadId m_Id;
    nn::hid::system::DeviceTypeSet m_DeviceType;
    int m_PlayerNumber;

    nn::hid::detail::PadDriverState m_PadDriverState;

    AnalogStickStateExFifo m_LeftAnalogStickFifo;
    AnalogStickStateExFifo m_RightAnalogStickFifo;
    SixAxisSensorDriverStateFifo m_SixAxisSensorFifo;
    RxPacketHistoryFifo m_RxPacketHistoryFifo;

    int64_t m_LastSamplingNumber;

public:
    NN_IMPLICIT UniquePadAccessor(const nn::hid::system::UniquePadId& id) NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    nn::hid::system::UniquePadId GetId() NN_NOEXCEPT;
    nn::hid::detail::PadDriverState GetPadDriverState() NN_NOEXCEPT;

    AnalogStickStateExFifo* GetAnalogStickFifo(DeviceIndex index) NN_NOEXCEPT;
    SixAxisSensorDriverStateFifo* GetSixAxisSensorFifo() NN_NOEXCEPT;
    RxPacketHistoryFifo* GetRxPacketHistoryFifo() NN_NOEXCEPT;
    nn::hid::system::DeviceTypeSet GetDeviceType() NN_NOEXCEPT;
    int GetPlayerNumber() NN_NOEXCEPT;
    void ResetFifo() NN_NOEXCEPT;

private:
    void UpdateState() NN_NOEXCEPT;
    void UpdateSixAxisSensorState() NN_NOEXCEPT;
};

class UniquePadList
{
private:
    UniquePadAccessor* m_pSelectedController;
    DeviceIndex m_PositionIndex;
    bool m_Selected;
    nn::os::SystemEventType m_UpdateEvent;

    typedef std::vector<UniquePadAccessor*> Array;
    Array m_List;

public:
    void Initialize() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
    bool GetSelectedController(UniquePadAccessor** pOutValue) NN_NOEXCEPT;
    bool GetSelectedDeviceIndex(DeviceIndex* pOutValue) NN_NOEXCEPT;
    void ClearSelectedController() NN_NOEXCEPT;
    void ResetSelectedControllerFifo() NN_NOEXCEPT;

    Array::iterator begin();
    Array::iterator end();

private:
    void UpdateSelectedDevice(UniquePadAccessor* pController,
                              DeviceIndex positionIndex) NN_NOEXCEPT;
};
