﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_MathTypes.h>

#include "s2d/Simple2D_Types.h"

// 定数
const s2d::Size ScreenSize = s2d::DefaultCanvasSize;
const float TextSize = 48.0f;
const float TextBaseScale = 0.32f;

// サイズ計算のためのマクロ
#define GET_SIZE_FROM_SCALE(scale)    TextSize * TextBaseScale * scale
#define GET_TEXTSCALE(xScale, yScale) { { { TextBaseScale * xScale, TextBaseScale * yScale } } }

//
// テキストのスケール定義一覧
//

const nn::util::Float2 TextScaleDefault                  =  GET_TEXTSCALE(1.0f, 1.0f);
const nn::util::Float2 TextScaleSmall                    =  GET_TEXTSCALE(0.8f, 0.8f);
const nn::util::Float2 TextScaleIndicator                =  GET_TEXTSCALE(0.5f, 0.5f);
const nn::util::Float2 TextScaleBattery                  =  GET_TEXTSCALE(0.5f, 1.0f);
const nn::util::Float2 TextScaleButton                   =  GET_TEXTSCALE(1.5f, 1.5f);
const nn::util::Float2 TextScaleStickEmulationHorizontal =  GET_TEXTSCALE(0.75f, 1.5f);
const nn::util::Float2 TextScaleStickEmulationVertical   =  GET_TEXTSCALE(1.5f, 0.75f);

//
// スクリーンのサイズの定義
//

const s2d::Size MenuSize    = { { GET_SIZE_FROM_SCALE(15.6f), ScreenSize.height } };
const s2d::Size HeaderSize  = { { ScreenSize.width - MenuSize.width, GET_SIZE_FROM_SCALE(2.0f) } };
const s2d::Size SceneSize   = { { HeaderSize.width, ScreenSize.height - HeaderSize.height } };


//
// サイズの定義一覧
// サイズは基本的に Scale から生成するようにします
//

const float YSizeLine               = GET_SIZE_FROM_SCALE(1.3f);
const float YSizeLineSmall          = GET_SIZE_FROM_SCALE(1.3f * 0.8f);
const float YSizeScroll             = YSizeLine * 0.25f;
const float YSizeColor              = YSizeLine * 0.75f;
const float YSizeUpperPadding       = YSizeLine * 0.5f;
const float YSizeTextInScene        = SceneSize.height - YSizeUpperPadding;

const float XSizePadding            = GET_SIZE_FROM_SCALE(0.3f);
const float XSizeIndex2Digit        = GET_SIZE_FROM_SCALE(2.0f);
const float XSizeTime               = GET_SIZE_FROM_SCALE(10.0f);
const float XSizeNpadLabel          = GET_SIZE_FROM_SCALE(3.9f);
const float XSizeChar               = GET_SIZE_FROM_SCALE(1.0f);
const float XSizeButtonUnit         = GET_SIZE_FROM_SCALE(1.3f);
const float XSizeButtonStickEmuNeg  = GET_SIZE_FROM_SCALE(0.286f);
const float XSizeButtonStickEmuPos  = GET_SIZE_FROM_SCALE(0.755f);
const float XSizeDeviceType         = GET_SIZE_FROM_SCALE(8.3f);
const float XSizeAssignment         = GET_SIZE_FROM_SCALE(2.0f);
const float XSizeBatteryUnit        = GET_SIZE_FROM_SCALE(0.4f);
const float XSizeColorLabel         = GET_SIZE_FROM_SCALE(3.0f);
const float XSizeColor              = GET_SIZE_FROM_SCALE(6.8f);
const float XSizeSystemExtStyle     = GET_SIZE_FROM_SCALE(18.2f);
const float XSizeSingleIndicator    = GET_SIZE_FROM_SCALE(0.5f);
const float XSizeId                 = XSizeSingleIndicator * 4 + XSizePadding;
const float XSizeSamplingNumber     = GET_SIZE_FROM_SCALE(6.2f);
const float XSizeStick              = GET_SIZE_FROM_SCALE(7.8f);
const float XSizeStyle              = GET_SIZE_FROM_SCALE(4.6f);
const float XSizeInterfaceType      = GET_SIZE_FROM_SCALE(6.0f);
const float XSizeVersion            = GET_SIZE_FROM_SCALE(9.0f);
const float XSizeControllerBorderIndent = GET_SIZE_FROM_SCALE(1.0f);

const float XSizePlayReportDeviceType = GET_SIZE_FROM_SCALE(6.5f);
const float XSizePlayReportStyle      = GET_SIZE_FROM_SCALE(18.0f);
const float XSizeVidPid               = GET_SIZE_FROM_SCALE(4.0f);
const float XSizeSubType              = GET_SIZE_FROM_SCALE(1.3f);

const float XSizeIdentificationCode = GET_SIZE_FROM_SCALE(18.0f);
const float XSizeAddress            = GET_SIZE_FROM_SCALE(9.0f);

const float XSizeLineChartLabel      = GET_SIZE_FROM_SCALE(3.4f);
const float XSizeLineChartValue      = GET_SIZE_FROM_SCALE(4.4f);
const float XSizeLineChartColorIndex = GET_SIZE_FROM_SCALE(1.0f);

const float XSizeLineChartFull      = SceneSize.width * 0.9f;

const float XSizePacketChartValue   = GET_SIZE_FROM_SCALE(4.4f);
const float XSizePacketChartHalf    = SceneSize.width * 0.45f;

const float SizeAnalogStickVectorChart = GET_SIZE_FROM_SCALE(21.0f);
const float YSizeAnalogStickLineChart  = SceneSize.height * 0.25f;

const float SizeSensorVectorChart      = GET_SIZE_FROM_SCALE(12.0f);
const float XSizeSensorVectorChartFull = SizeSensorVectorChart + XSizeLineChartLabel * 4;
const float YSizeSensorLineChart       = SceneSize.height * 0.15f;
const float YSizeSensorLineChartFull   = YSizeSensorLineChart + YSizeLineSmall * 6;
const float YSizeSensorDriverLineChart = SceneSize.height * 0.30f;
const float YSizeSensorDriverLineChartFull   = YSizeSensorDriverLineChart + YSizeLineSmall * 6;

const float YSizeRxMonitorLineChart = SceneSize.height * 0.15f;
const float YSizeRxMonitorLineChartFull = YSizeRxMonitorLineChart + YSizeLineSmall * 6;
const float YSizeRxMonitorPacketChart = 10.0f;
const float YSizeRxMonitorPacketChartFull = YSizeRxMonitorPacketChart + YSizeLineSmall;

const float XSizeMenu               = GET_SIZE_FROM_SCALE(10.9f);
const float XSizeMenuItemIndent     = GET_SIZE_FROM_SCALE(1.5f);

const float SizeControllerBorder    = SceneSize.width - (XSizePadding * 3 + XSizeControllerBorderIndent) * 2;

const float WidthBorderDefault      = 1.0f;
const float WidthBorderDefaultBold  = 2.0f;
const float WidthBorderDefaultBold02= 4.0f;

const float SizeLineChartPlot       = 4.0f;

const float YSizeHeaderPadding      = (HeaderSize.height - GET_SIZE_FROM_SCALE(1.0f)) / 2;

const float YSizeScrollBarPadding   = GET_SIZE_FROM_SCALE(0.3f);
const float YSizeScrollBar          = SceneSize.height - YSizeScrollBarPadding * 2;
const float XSizeScrollBar          = GET_SIZE_FROM_SCALE(0.5f);

//
// 2D 座標の定義一覧
//

//!< メニューの左上座標
const s2d::Point2D PositionMenu       = { { 0.0f, 0.0f } };
//!< メニューのテキスト開始位置
const s2d::Point2D PositionMenuText   = { { PositionMenu.x, PositionMenu.y + YSizeUpperPadding } };

//!< ヘッダーの位置
const s2d::Point2D PositionHeader     = { { PositionMenu.x + MenuSize.width,
                                        PositionMenu.y } };

//!< シーンの左上座標
const s2d::Point2D PositionScene      = { { PositionHeader.x,
                                        PositionHeader.y + HeaderSize.height } };
//!< シーンのテキスト開始位置
const s2d::Point2D PositionSceneText  = { { PositionScene.x + XSizePadding * 3,
                                        PositionScene.y + YSizeUpperPadding } };
//!< シーンのスクロールバーの開始位置
const s2d::Point2D PositionScrollStart = { { PositionScene.x + SceneSize.width - XSizePadding * 3,
                                             PositionScene.y + YSizeScrollBarPadding} };
const s2d::Point2D PositionScrollEnd   = { { PositionScrollStart.x,
                                             PositionScrollStart.y + YSizeScrollBar } };

//
// 色の定義一覧
//

const s2d::Color ColorSceneBackground   = { { 0xFC, 0xFC, 0xFC, 255 } };
const s2d::Color ColorSceneTextDefault  = { { 0x30, 0x30, 0x30, 255 } };
const s2d::Color ColorSceneTextStrong01 = { { 0x49, 0xA5, 0xD8, 255 } };
const s2d::Color ColorSceneTextStrong02 = { { 0xCA, 0x00, 0x07, 255 } };
const s2d::Color ColorSceneTextStrong03 = { { 0xFF, 0x00, 0x99, 255 } };
const s2d::Color ColorSceneTextStrong04 = { { 0xF3, 0xE2, 0x00, 255 } };
const s2d::Color ColorSceneBatteryOn    = ColorSceneTextStrong01;
const s2d::Color ColorSceneBatteryOff   = { { 0xC0, 0xC0, 0xC0, 255 } };
const s2d::Color ColorSceneBorder       = { { 0xb0, 0xb0, 0xb0, 255 } };
const s2d::Color ColorSceneBorderBold   = ColorSceneTextDefault;
const s2d::Color ColorSceneBorderLight  = { { 0xd2, 0xd2, 0xd2, 255 } };
const s2d::Color ColorSceneIndicator    = { {   0, 255,   0, 255 } };

const s2d::Color ColorSceneGraphLine[] = {
    { { 0xE4, 0x00, 0x7F, 255 } },
    { { 0xFF, 0xF1, 0x00, 255 } },
    { { 0x00, 0x68, 0xB7, 255 } },
    { { 0x8F, 0xC3, 0x1F, 255 } },
    { { 0xE6, 0x00, 0x12, 255 } },
    { { 0x1D, 0x20, 0x88, 255 } },
    { { 0x00, 0x99, 0x44, 255 } },
    { { 0x92, 0x07, 0x83, 255 } },
    { { 0x00, 0xA0, 0xE9, 255 } },
    { { 0xF3, 0x98, 0x00, 255 } },
    { { 0x00, 0x9E, 0x96, 255 } },
    { { 0xE3, 0x50, 0x4F, 255 } },
};

const s2d::Color ColorMenuBackground    = { { 0x30, 0x30, 0x30, 255 } };
const s2d::Color ColorMenuTextDefault   = { { 0xFC, 0xFC, 0xFC, 255 } };
const s2d::Color ColorMenuTextStrong    = { { 0xEB, 0xB8, 0x48, 255 } };
