﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/system/hid_RegisteredDevice.h>
#include <nn/hid/debug/hid_RegisteredDevice.h>

#include "SceneRegisteredDevice.h"
#include "ScreenStatics.h"
#include "ScreenUtil.h"
#include "s2d/Simple2D.h"


nn::hid::system::RegisteredDevice g_Device;

void DrawIdentificationCode(RecordablePosition& position, char idCode[16])
{
    position.x += PrintAndStep(position.Get(), "S/N: ");
    idCode[15] = '\0';
    s2d::DrawText(position.Get(), "%s", idCode);
    position.x += XSizeIdentificationCode;
}

void DrawAddress(RecordablePosition& position, nn::bluetooth::Address address)
{
    s2d::DrawText(position.Get(), "%02x:%02x:%02x:%02x:%02x:%02x",
        address.address[0], address.address[1], address.address[2], address.address[3], address.address[4], address.address[5]);
    position.x += XSizeAddress;
}

void DrawLinkKey(RecordablePosition& position, nn::Bit8* pLinkKeys)
{
    s2d::DrawText(position.Get(), "%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x",
        pLinkKeys[0], pLinkKeys[1], pLinkKeys[2], pLinkKeys[3], pLinkKeys[4], pLinkKeys[5],
        pLinkKeys[6], pLinkKeys[7], pLinkKeys[8], pLinkKeys[9], pLinkKeys[10], pLinkKeys[11],
        pLinkKeys[11], pLinkKeys[12], pLinkKeys[13], pLinkKeys[14], pLinkKeys[15]);
    position.x += XSizeAddress * 4;
}

void DrawBdName(RecordablePosition& position, char* pName)
{
    s2d::DrawText(position.Get(), "%s", pName);

    position.x += XSizeAddress * 3;
}

void SceneRegisteredDevice::DrawImpl(RecordablePosition& position) NN_NOEXCEPT
{
    nn::hid::system::RegisteredDevice devices[nn::hid::system::RegisteredDeviceCountMax];
    auto count = nn::hid::system::GetRegisteredDevices(devices, NN_ARRAY_SIZE(devices));

    for (int i = 0; i < count; ++i)
    {
        position.x =             PositionSceneText.x;
        position.x += XSizeIndex2Digit;

        auto& device = devices[i];
        DrawAddress(position, device.address);
        DrawDeviceType(position, device.deviceType);
        DrawIdentificationCode(position, device.identificationCode);
        DrawInterface(position, device.interfaceType);
        position.NewLine();
        position.x = PositionSceneText.x + XSizeIndex2Digit;
        DrawLinkKey(position, device.linkKey.raw);
        DrawBdName(position, device.bdName.raw);
        position.NewLine();
        position.x = PositionSceneText.x + XSizeIndex2Digit;
        s2d::DrawText(position.Get(), "Main:");
        position.x += XSizeColorLabel;
        DrawColor(position, device.mainColor);
        s2d::DrawText(position.Get(), "Sub:");
        position.x += XSizeColorLabel;
        DrawColor(position, device.subColor);
        s2d::DrawText(position.Get(), "3rd:");
        position.x += XSizeColorLabel;
        DrawColor(position, device.thirdColor);
        s2d::DrawText(position.Get(), "4th:");
        position.x += XSizeColorLabel;
        DrawColor(position, device.forthColor);
        position.NewLine();
    }
}
