﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

template <typename T, int TSize>
class RingBuffer : public std::vector<T>
{
private:
    static const int Size = TSize;

public:
    void push_back(const T& x) NN_NOEXCEPT
    {
        if (this->size() == Size)
        {
            this->erase(this->begin());
        }
        std::vector<T>::push_back(x);
    }
};
