﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_PlayReport.h>
#include <nn/time/time_CalendarTime.h>

#include "RingBuffer.h"

struct PackedControllerUsages
{
    nn::hid::system::PlayReportControllerUsage usages[nn::hid::system::PlayReportControllerUsageCountMax];
    int count;
    nn::time::CalendarTime time;
};

const int ControllerUsagesCountMax = 20;
typedef RingBuffer<PackedControllerUsages, ControllerUsagesCountMax> ControllerUsagesBuffer;

class PlayReportUsageMonitor
{
NN_DISALLOW_COPY(PlayReportUsageMonitor);
NN_DISALLOW_MOVE(PlayReportUsageMonitor);

public:

private:
    ControllerUsagesBuffer m_Buffer;

public:
    PlayReportUsageMonitor() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
    const ControllerUsagesBuffer& GetUsages() NN_NOEXCEPT;

    static PlayReportUsageMonitor& GetInstance()
    {
        static PlayReportUsageMonitor s_Instance;
        return s_Instance;
    }
};
