﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/hid/hid_Palma.h>

class PalmaHandler
{
    NN_DISALLOW_COPY(PalmaHandler);
    NN_DISALLOW_MOVE(PalmaHandler);

private:
    nn::hid::PalmaConnectionHandle m_Handle;
    nn::hid::NpadIdType m_NpadId;

public:
    PalmaHandler() NN_NOEXCEPT;

    void Initialize(const nn::hid::NpadIdType& id) NN_NOEXCEPT;
    void Update(bool styleAvailable) NN_NOEXCEPT;
    static void StartScan() NN_NOEXCEPT;
    static void StopScan() NN_NOEXCEPT;
    static void StartPairing() NN_NOEXCEPT;
    static void StopPairing() NN_NOEXCEPT;
};
