﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadGc.h>
#include <nn/hid/hid_NpadPalma.h>
#include <nn/hid/system/hid_Npad.h>

#include "NpadCommonState.h"

struct NpadStyleDefinition
{
    nn::hid::NpadStyleSet style;
    std::string styleString;
    std::string styleStringShort;
    int(*pFunc)(AbstractedNpadState* pOutState, int size, const nn::hid::NpadIdType&);
};

const NpadStyleDefinition NpadStyles[] = {
    {nn::hid::NpadStyleFullKey::Mask,            "FullKey",   "FK", GetAbstractedNpadStates<nn::hid::NpadFullKeyState>},
    {nn::hid::NpadStyleHandheld::Mask,           "Handheld",  "HH", GetAbstractedNpadStates<nn::hid::NpadHandheldState>},
    {nn::hid::NpadStyleJoyDual::Mask,            "JoyDual",   "JD", GetAbstractedNpadStates<nn::hid::NpadJoyDualState>},
    {nn::hid::NpadStyleJoyLeft::Mask,            "JoyLeft",   "JL", GetAbstractedNpadStates<nn::hid::NpadJoyLeftState>},
    {nn::hid::NpadStyleJoyRight::Mask,           "JoyRight",  "JR", GetAbstractedNpadStates<nn::hid::NpadJoyRightState>},
    {nn::hid::NpadStyleGc::Mask,                 "Gc",        "GC", GetAbstractedNpadStates<nn::hid::NpadGcState>},
    {nn::hid::NpadStylePalma::Mask,              "Palma",     "PL", GetAbstractedNpadStates<nn::hid::NpadPalmaState>},
//    {nn::hid::system::NpadStyleSystem::Mask,     "System",    "SY", GetAbstractedNpadSystemState<nn::hid::system::NpadSystemState>},
    {nn::hid::system::NpadStyleSystemExt::Mask,  "SystemExt", "SX", GetAbstractedNpadSystemStates<nn::hid::system::NpadSystemExtState>},
};

const int NpadStyleCountMax = NN_ARRAY_SIZE(NpadStyles);
