﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Menu.h"
#include "MenuTop.h"
#include "ScreenStatics.h"

namespace {

MenuItemTestToolTop*    g_pMenuItemTestToolTop;               // Npad のテストモードのメニュー

}

void InitializeMenu()
{
    g_pMenuItemTestToolTop = new MenuItemTestToolTop();
    g_pMenuItemTestToolTop->Select();
    g_pMenuItemTestToolTop->Update();
}

void DrawMenu() NN_NOEXCEPT
{
    // メニューの背景色の塗りつぶし
    s2d::Point2D position = PositionMenu;
    s2d::Rectangle menuBg = { { position.x, position.y, MenuSize.width, MenuSize.height } };
    s2d::FillRectangle(menuBg, ColorMenuBackground);

    // メニューの描画
    s2d::SetTextColor(ColorMenuTextDefault);
    position = PositionMenuText;
    g_pMenuItemTestToolTop->Print(position, 0);

    // カーソルの描画
    int cursorIndex = 0;
    int cursorDepth = 0;
    g_pMenuItemTestToolTop->GetItemIndex(&cursorIndex, &cursorDepth);
    position = PositionMenuText;
    position.x += XSizePadding + cursorDepth * XSizeMenuItemIndent;
    position.y += cursorIndex * YSizeLine;
    s2d::SetTextColor(ColorMenuTextStrong);
    s2d::DrawText(position, "\uE14A");
    s2d::SetTextColor(ColorMenuTextDefault);

    // メニュー操作方法の描画
    position = PositionMenuText;
    position.x += XSizeMenuItemIndent;
    position.y = MenuSize.height - YSizeLine * 3.5;
    s2d::SetTextColor(ColorMenuTextDefault);
    s2d::DrawText(position, "\uE0EB/\uE0EC Cursor  \uE0ED/\uE0EE Value");
    position.y += YSizeLine;
    s2d::DrawText(position, "\uE0E0 Select \uE0E1 Cancel");
    position.y += YSizeLine;
    s2d::DrawText(position, "\uE0E4/\uE0E5 Switch Mode");
    position.y += YSizeLine;
}

void ControlMenu(const PackedButton& button) NN_NOEXCEPT
{
    if (button.trigger.Test<nn::hid::NpadButton::A>())
    {
        if (g_pMenuItemTestToolTop->Select() == true)
        {
            g_pMenuItemTestToolTop->Select();
        }
        g_pMenuItemTestToolTop->Update();
    }
    if (button.trigger.Test<nn::hid::NpadButton::B>())
    {
        if (g_pMenuItemTestToolTop->Cancel() == true)
        {
            g_pMenuItemTestToolTop->Select();
        }
        g_pMenuItemTestToolTop->Update();
    }
    if (button.trigger.Test<nn::hid::NpadButton::Right>() ||
        button.trigger.Test<nn::hid::NpadButton::StickLRight>())
    {
        g_pMenuItemTestToolTop->NextValue(true);
    }
    if (button.trigger.Test<nn::hid::NpadButton::Left>() ||
        button.trigger.Test<nn::hid::NpadButton::StickLLeft>())
    {
        g_pMenuItemTestToolTop->PrevValue(true);
    }

    auto triggerWithRepeat = button.trigger | button.repeat;
    if (triggerWithRepeat.Test<nn::hid::NpadButton::Up>() ||
        triggerWithRepeat.Test<nn::hid::NpadButton::StickLUp>())
    {
        g_pMenuItemTestToolTop->PrevItem();
    }
    if (triggerWithRepeat.Test<nn::hid::NpadButton::Down>() ||
        triggerWithRepeat.Test<nn::hid::NpadButton::StickLDown>())
    {
        g_pMenuItemTestToolTop->NextItem();
    }
}
