﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/time/time_CalendarTime.h>

#include "RingBuffer.h"

static const int LogUnitLengthMax = 128;
static const int LogCountMax = 256;

struct PackedLog
{
    char log[LogUnitLengthMax];
    bool isWarn;
    nn::time::CalendarTime time;
};

typedef RingBuffer<PackedLog, LogCountMax> LogRingBuffer;

void PrintLog(bool warn, const char* format, ...) NN_NOEXCEPT;
const LogRingBuffer& GetLogs() NN_NOEXCEPT;

#define HID_TOOL_LOG(...) PrintLog(false, __VA_ARGS__);
#define HID_TOOL_WARN(...) PrintLog(true, __VA_ARGS__);
