﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdlib>
#include <string>
#include <vector>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

#include <FontSys.h>
#include <GraphicsSys.h>
#include <Color.h>
#include <frm_Npad.h>

namespace main {

    class Menu
    {
    public:
        enum Menustate
        {
            Menustate_Set,       //!< メニュー選択
            Menustate_Ready,     //!< メニュー決定
            Menustate_Do,        //!< メニュー項目実行
        };

    public:
        void SetList(std::string* menulist, int menunum, std::string* cmnmenulist, int cmnmenunum) NN_NOEXCEPT;
        void ResetList() NN_NOEXCEPT;
        int Select(frm::hid::NPadState m_BtnSt) NN_NOEXCEPT;
        int Deside(frm::hid::NPadState m_BtnSt) NN_NOEXCEPT;
        void DrawLegacy(nn::gfx::util::DebugFontTextWriter* pTextWriter, GraphicsSystem* pGraphicsSystem, int ofsX, int ofsY) NN_NOEXCEPT;
        void DrawRing(nn::gfx::util::DebugFontTextWriter* pTextWriter, GraphicsSystem* pGraphicsSystem, int ofsX, int ofsY) NN_NOEXCEPT;
        void SetTouchPosition(int32_t TouchPos) NN_NOEXCEPT;
        Menustate GetMenuState(frm::hid::NPadState m_BtnSt) NN_NOEXCEPT;
        Menustate ForceSetMenuState(Menustate St) NN_NOEXCEPT;

    private:
        void DrawRect(GraphicsSystem* pGraphicsSystem, float ofsX, float ofsY, float menuNum) NN_NOEXCEPT;

    };
}
