﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_NpadJoyDual.h>
#include <nn/mem/mem_StandardAllocator.h>

#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>

//!< ConsoleSixAxisSensor 向けの処理を記述したクラスです。
class ConsoleSixAxisSensorSampler
{
    NN_DISALLOW_COPY(ConsoleSixAxisSensorSampler);
    NN_DISALLOW_MOVE(ConsoleSixAxisSensorSampler);

private:
    ::nn::hid::ConsoleSixAxisSensorHandle m_Handle;
    ::nn::hid::tmp::SixAxisSensorCountState m_States[::nn::hid::ConsoleSixAxisSensorStateCountMax];
    bool m_IsSamplingStarted;

    nn::mem::StandardAllocator m_Allocator;
    void* m_pWorkBuffer;

public:
    ConsoleSixAxisSensorSampler() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;

    void StartSampling() NN_NOEXCEPT;

    void StopSampling() NN_NOEXCEPT;

    bool IsSamplingStarted() const NN_NOEXCEPT;

    int GetCountStates(::nn::hid::tmp::SixAxisSensorCountState* pOutStates, int count) NN_NOEXCEPT;

    int GetStates(::nn::hid::SevenSixAxisSensorState* pOutStates, int count) NN_NOEXCEPT;
};

