﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>

#include "ConsoleSixAxisSensorSampler.h"

namespace {

const size_t ApplicationHeapSize = 128 * 1024 * 1024;

} // namespace

ConsoleSixAxisSensorSampler::ConsoleSixAxisSensorSampler() NN_NOEXCEPT
    : m_Handle()
    , m_IsSamplingStarted(false)
{
    nn::Bit8* pAppMemory = new nn::Bit8[ApplicationHeapSize];
    m_Allocator.Initialize(pAppMemory, ApplicationHeapSize);
    m_pWorkBuffer = m_Allocator.Allocate(::nn::hid::SevenSixAxisSensorWorkBufferSize, 4096);
}

void ConsoleSixAxisSensorSampler::Initialize() NN_NOEXCEPT
{
    ::nn::hid::InitializeSevenSixAxisSensor(m_pWorkBuffer,
                                            ::nn::hid::SevenSixAxisSensorWorkBufferSize);
    ::nn::hid::GetSixAxisSensorHandle(&m_Handle);
}

void ConsoleSixAxisSensorSampler::StartSampling() NN_NOEXCEPT
{
    NN_LOG("StartSevenSixAxisSensor()\n");
    m_IsSamplingStarted = true;
    ::nn::hid::StartSevenSixAxisSensor();
}

void ConsoleSixAxisSensorSampler::StopSampling() NN_NOEXCEPT
{
    NN_LOG("StopSevenSixAxisSensor()\n");
    m_IsSamplingStarted = false;
    ::nn::hid::StopSevenSixAxisSensor();
}

bool ConsoleSixAxisSensorSampler::IsSamplingStarted() const NN_NOEXCEPT
{
    return m_IsSamplingStarted;
}

int ConsoleSixAxisSensorSampler::GetStates(::nn::hid::SevenSixAxisSensorState* pOutStates,
                                           int count) NN_NOEXCEPT
{
    return ::nn::hid::GetSevenSixAxisSensorStates(pOutStates, count);
}

int ConsoleSixAxisSensorSampler::GetCountStates(::nn::hid::tmp::SixAxisSensorCountState* pOutStates,
                                                int count) NN_NOEXCEPT
{
    return 0;
}
