﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/hid_Xpad.h>
#include <nnt/nntest.h>

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_GCC)
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_VC)
#pragma warning(disable:4996)
#endif

namespace {

::nn::hid::BasicXpadId g_BasicXpadIds[::nn::hid::XpadIdCountMax];

} // namespace

//!< プレイヤー番号は正しく取得されるか
TEST(XpadPlayerNumberSuite, PlayerNumberTest1)
{
    const int count = ::nn::hid::GetXpadIds(&g_BasicXpadIds[0],
                                            ::nn::hid::XpadIdCountMax);

    for (int i = 0; i < count; ++i)
    {
        EXPECT_LE(0, ::nn::hid::GetXpadPlayerNumber(g_BasicXpadIds[i]));
    }

    for (int i = 1; i < count; ++i)
    {
        EXPECT_LT(::nn::hid::GetXpadPlayerNumber(g_BasicXpadIds[i - 1]),
                  ::nn::hid::GetXpadPlayerNumber(g_BasicXpadIds[i]));
    }
}
