﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid.h>
#include <nn/hid/debug/hid_Xpad.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG)
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_GCC)
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_VC)
#pragma warning(disable:4996)
#endif

#include "../Common/testHid_Xpad.h"

namespace
{

::nn::hid::BasicXpadId g_BasicXpadIds[::nn::hid::XpadIdCountMax];

} // namespace

class XpadPerformanceSuiteWithParam : public ::testing::TestWithParam<int>
{
};

INSTANTIATE_TEST_CASE_P(
    XpadPerformanceSuite,
    XpadPerformanceSuiteWithParam,
    ::testing::Range(0, 4));

//!< 入力状態は 5 ms 以上の間隔を開けて追加されるか
TEST_P(XpadPerformanceSuiteWithParam, StateReadingTest1)
{
    const int xpadIdIndex = GetParam();

    const int xpadIdCount =
        ::nn::hid::GetXpadIds(g_BasicXpadIds, ::nn::hid::XpadIdCountMax);
    ASSERT_GE(::nn::hid::XpadIdCountMax, xpadIdCount);
    ASSERT_GT(xpadIdCount, xpadIdIndex);

    const ::nn::hid::BasicXpadId& xpadId = g_BasicXpadIds[xpadIdIndex];

    for (int i = 0; i < xpadIdCount; ++i)
    {
        ::nn::hid::InitializeXpad(g_BasicXpadIds[i]);
    }

    ::nn::hid::BasicXpadState state1 = {};

    ::nn::hid::GetXpadState(&state1, xpadId);

    int64_t expectedCount = ::nn::hid::XpadStateCountMax / 2;

    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            expectedCount *
            ::nnt::hid::GetXpadSamplingInterval().GetMilliSeconds()));

    ::nn::hid::BasicXpadState state2 = {};

    ::nn::hid::GetXpadState(&state2, xpadId);

    int64_t observedCount = state2.samplingNumber - state1.samplingNumber + 1;

    EXPECT_LE(expectedCount - 2, observedCount);
    EXPECT_GE(expectedCount + 2, observedCount);

    for (int i = 0; i < xpadIdCount; ++i)
    {
        ::nn::hid::debug::FinalizeXpad(g_BasicXpadIds[i]);
    }
}
