﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/hid/hid_VibrationPermissionApi.h>

//!< 振動の許可状況を取得可能か
TEST(VibrationPermissionSuite, VibrationPermissionTest1)
{
    ::nn::hid::IsVibrationPermitted();
}

//!< 振動の許可状況を変更可能か
TEST(VibrationPermissionSuite, VibrationPermissionTest2)
{
    bool originalState = ::nn::hid::IsVibrationPermitted();
    bool newState = !originalState;

    ::nn::hid::PermitVibration(newState);
    EXPECT_EQ(newState, ::nn::hid::IsVibrationPermitted());

    ::nn::hid::PermitVibration(originalState);
    EXPECT_EQ(originalState, ::nn::hid::IsVibrationPermitted());
}

//!< 振動の一時的許可が可能か
TEST(VibrationPermissionSuite, VibrationPermissionTest３)
{
    bool originalState = ::nn::hid::IsVibrationPermitted();

    {
        // 強制振動ONを実行しても、NANDの値が変わらないことの確認
        ::nn::hid::BeginForcedVibrationSession();
        bool beginState = ::nn::hid::IsVibrationPermitted();
        EXPECT_EQ(originalState, beginState);

        ::nn::hid::EndForcedVibrationSession();
        bool endState = ::nn::hid::IsVibrationPermitted();
        EXPECT_EQ(originalState, endState);
    }

    bool newState = !originalState;
    ::nn::hid::PermitVibration(newState);
    EXPECT_EQ(newState, ::nn::hid::IsVibrationPermitted());

    {
        // 強制振動ONを実行しても、NANDの値が変わらないことの確認
        ::nn::hid::BeginForcedVibrationSession();
        bool beginState = ::nn::hid::IsVibrationPermitted();
        EXPECT_EQ(newState, beginState);

        ::nn::hid::EndForcedVibrationSession();
        bool endState = ::nn::hid::IsVibrationPermitted();

        EXPECT_EQ(newState, endState);
    }

    ::nn::hid::PermitVibration(originalState);
    EXPECT_EQ(originalState, ::nn::hid::IsVibrationPermitted());
}

//!< 振動の許可状況を変更　正常系
TEST(VibrationPermissionSuite, VibrationPermissionTest4)
{
    ::nn::hid::BeginForcedVibrationSession();
    ::nn::hid::EndForcedVibrationSession();
}

//!< 振動の許可状況を変更　異常系
TEST(VibrationPermissionSuite, VibrationPermissionTest5)
{
    ::nn::hid::EndForcedVibrationSession();
}

//!< 振動の許可状況を変更　異常系
TEST(VibrationPermissionSuite, VibrationPermissionTest6)
{
    ::nn::hid::BeginForcedVibrationSession();
    ::nn::hid::BeginForcedVibrationSession();

    ::nn::hid::EndForcedVibrationSession();
    ::nn::hid::EndForcedVibrationSession();
}
