﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>

//!< BindUniquePadConnectionEvent の呼出し
TEST(UniquePadEventSuite, BindTest1)
{
    auto event1 = ::nn::os::SystemEventType();

    ::nn::hid::system::BindUniquePadConnectionEvent(&event1,
                                                    ::nn::os::EventClearMode_AutoClear);
    ::nn::os::DestroySystemEvent(&event1);
}

//!< バインド直後の UniquePad の接続通知はシグナルされているか
TEST(UniquePadEventSuite, SignalTest1)
{
    auto event = ::nn::os::SystemEventType();

    ::nn::hid::system::BindUniquePadConnectionEvent(&event,
                                                    ::nn::os::EventClearMode_AutoClear);

    EXPECT_TRUE(::nn::os::TryWaitSystemEvent(&event));
}
