﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/system/hid_SleepButton.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>

namespace
{

//!< イベントのシグナル状況を確認するか否かを表す値です。
const bool EnablesSignalAsserion =
#if defined(NN_BUILD_CONFIG_OS_WIN)
    true;
#else
    false;
#endif

} // namespace

//!< バインド直後のホームボタンの入力通知はシグナルされているか
TEST(SleepButtonEventSuite, SignalTest1)
{
    ::nn::os::SystemEventType event = {};

    ::nn::hid::system::BindSleepButtonEvent(&event,
                                            ::nn::os::EventClearMode_AutoClear);

    if (NN_STATIC_CONDITION(EnablesSignalAsserion))
    {
        EXPECT_TRUE(::nn::os::TryWaitSystemEvent(&event));
    }

    ::nn::os::DestroySystemEvent(&event);
}
