﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/hid/system/hid_SixAxisSensorCalibration.h>
#include <nn/hid/system/hid_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include <nnt/nntest.h>


//!< API 呼出しが可能か
TEST(SixAxisSensorCalibration, ApiCallBasic)
{
    // UniquePadId の取得
    ::nn::hid::system::UniquePadId ids[::nn::hid::system::UniquePadIdCountMax];
    const int IdCount = ::nn::hid::system::ListUniquePads(ids, sizeof(ids) / sizeof(ids[0]));
    ASSERT_GE(::nn::hid::system::UniquePadIdCountMax, IdCount);

    // UniquePadSixAxisSensorHandle を取得
    ::nn::hid::system::UniqueSixAxisSensorHandle handles[::nn::hid::system::UniqueSixAxisSensorHandleCountMax];

    int handleCount = 0;
    for(int i = 0; i < IdCount; i++)
    {
        int count = ::nn::hid::system::ListSixAxisSensorHandles(&handles[handleCount],
                                                                ids[i],
                                                                ::nn::hid::system::UniquePadIdCountMax);
        handleCount += count;
    }
    ASSERT_GE(::nn::hid::system::UniqueSixAxisSensorHandleCountMax, handleCount);

    for(int i = 0; i < handleCount; i++)
    {
        // const bool IsSupported = ::nn::hid::system::IsSixAxisSensorUserCalibrationSupported(handles[i]);
        // EXPECT_TRUE(!IsSupported);

        auto result = ::nn::hid::system::ResetSixAxisSensorCalibrationValues(handles[i]);

        EXPECT_TRUE(::nn::hid::system::ResultSixAxisSensorDisconnected::Includes(result) ||
                    ::nn::hid::system::ResultSixAxisSensorNotSupported::Includes(result) ||
                    ::nn::hid::system::ResultSixAxisSensorWriteFailure::Includes(result) ||
                    result.IsSuccess());

        result = ::nn::hid::system::StartSixAxisSensorUserCalibration(handles[i]);

        EXPECT_TRUE(::nn::hid::system::ResultSixAxisSensorDisconnected::Includes(result)  ||
                    ::nn::hid::system::ResultSixAxisSensorNotSupported::Includes(result)  ||
                    ::nn::hid::system::ResultSixAxisSensorNotStable::Includes(result)     ||
                    ::nn::hid::system::ResultSixAxisSensorNotHorizontal::Includes(result) ||
                    ::nn::hid::system::ResultSixAxisSensorWriteFailure::Includes(result)  ||
                    result.IsSuccess());
    }
}
