﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nnt/nntest.h>

#include "testHid_NpadCommon.h"
#include "../Common/testHid_Npad.h"

namespace {

void TestPowerInfo(nn::hid::system::NpadPowerInfo& powerInfo, bool deviceAvailable)
{
    if (deviceAvailable)
    {
        EXPECT_GE(powerInfo.batteryLevel, nn::hid::system::NpadBatteryLevel_CriticalLow);
    }
    else
    {
        EXPECT_EQ(powerInfo.batteryLevel, nn::hid::system::NpadBatteryLevel_None);
        EXPECT_FALSE(powerInfo.isCharging);
        EXPECT_FALSE(powerInfo.isPowered);
    }
}

}

//!< 本体機能向けの各入力状態の未接続状態検出
TEST(NpadSystemInfo, NoDeviceConnected)
{
    testhid::EnableIdAll();

    for (auto& npadId : ::testhid::NpadIds)
    {
        nn::hid::system::NpadPowerInfo right;
        nn::hid::system::NpadPowerInfo left;
        nn::hid::system::NpadPowerInfo fullKey;

        auto deviceType = nn::hid::system::GetNpadDeviceType(npadId);

        // 電源状態の読み出し
        fullKey = nn::hid::system::GetNpadPowerInfo(npadId);
        nn::hid::system::GetNpadPowerInfo(&left, &right, npadId);

        // 電源状態のチェック
        {
            SCOPED_TRACE("FullKey");
            TestPowerInfo(fullKey, deviceType.IsAnyOn());
        }
        {
            SCOPED_TRACE("Left");
            TestPowerInfo(left,    (deviceType & (nn::hid::system::NpadDeviceType::JoyConLeft::Mask |
                                                  nn::hid::system::NpadDeviceType::HandheldJoyLeft::Mask)).IsAnyOn());
        }
        {
            SCOPED_TRACE("Right");
            TestPowerInfo(right,   (deviceType & (nn::hid::system::NpadDeviceType::JoyConRight::Mask |
                                                  nn::hid::system::NpadDeviceType::HandheldJoyRight::Mask)).IsAnyOn());
        }
        EXPECT_TRUE(nn::hid::system::IsAbxyButtonOriented(npadId));
        EXPECT_FALSE(nn::hid::system::IsSlSrButtonOriented(npadId));
        EXPECT_FALSE(nn::hid::system::IsUnsupportedButtonPressed(npadId, nn::hid::system::NpadStyleSystem::Mask));
        EXPECT_FALSE(nn::hid::system::IsUnsupportedButtonPressed(npadId, nn::hid::system::NpadStyleSystemExt::Mask));
    }

    testhid::DisableIdAll();
}

