﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Result.h>
#include <nnt/nntest.h>

#include "testHid_NpadCommon.h"
#include "../Common/testHid_Npad.h"

//!< 有効な Npad が存在するときの動作
TEST(NpadLrAssignmentMode, NpadSupported)
{
    ::testhid::EnableIdAll();

    // 開始前に呼んでも問題ない
    nn::hid::StopLrAssignmentMode();

    // 開始
    nn::hid::StartLrAssignmentMode();

    // 持ち方の設定に影響は与えない
    auto holdType = nn::hid::GetNpadJoyHoldType();
    EXPECT_EQ(nn::hid::NpadJoyHoldType_Vertical, holdType);

    // Npad の割り当てモードに対しては影響を与えない
    for (auto& npadId : ::testhid::NpadIds)
    {
        auto assignment = nn::hid::GetNpadJoyAssignment(npadId);
        EXPECT_EQ(nn::hid::NpadJoyAssignmentMode_Dual, assignment);
    }

    // 2度呼んでも問題ない
    nn::hid::StartLrAssignmentMode();

    // 停止
    nn::hid::StopLrAssignmentMode();

    // 2度呼んでも問題ない
    nn::hid::StopLrAssignmentMode();

    ::testhid::DisableIdAll();
}
