﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/debug/hid_Keyboard.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#include "../Common/testHid_Keyboard.h"

//!< 入力状態は 8 ms 以上の間隔を開けて追加されるか
TEST(KeyboardPerformanceSuite, StateReadingTest1)
{
    ::nn::hid::InitializeKeyboard();

    ::nn::hid::KeyboardState state1 = {};

    ::nn::hid::GetKeyboardState(&state1);

    int64_t expectedCount = ::nn::hid::KeyboardStateCountMax / 2;

    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            expectedCount *
            ::nnt::hid::GetKeyboardSamplingInterval().GetMilliSeconds()));

    ::nn::hid::KeyboardState state2 = {};

    ::nn::hid::GetKeyboardState(&state2);

    int64_t observedCount = state2.samplingNumber - state1.samplingNumber + 1;

    EXPECT_LE(expectedCount - 2, observedCount);
    EXPECT_GE(expectedCount + 2, observedCount);

    ::nn::hid::debug::FinalizeKeyboard();
}
