﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/hid/debug/hid_InputDetection.h>
#include <nn/hid/system/hid_InputDetection.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>

#include "../Common/testHid_InputDetector.h"

namespace
{
::nn::hid::system::InputSourceState g_State;
} // namespace

//!< InputDetector の初期化状態は GetInputDetectorStates() の呼び出しに反映されるか
TEST(InputDetectorInitializationSuite, NoInitializationTest1)
{
    for (const auto& id : nnt::hid::InputSourceIdSets)
    {
        // InputDetector が未初期化の状態で呼び出すとアボートする。
        EXPECT_DEATH_IF_SUPPORTED(
            ::nn::hid::system::GetInputSourceState(&g_State, id), "");

        ::nn::hid::system::InitializeInputDetector();

        ::nn::hid::system::InitializeInputDetector();

        ::nn::hid::debug::FinalizeInputDetector();

        // InputDetector が終了しきっていないので成功する。
        ::nn::hid::system::GetInputSourceState(&g_State, id);

        ::nn::hid::debug::FinalizeInputDetector();

        // InputDetector の終了処理後に呼び出すとアボートする。
        EXPECT_DEATH_IF_SUPPORTED(
            ::nn::hid::system::GetInputSourceState(&g_State, id), "");
    }
}

//!< InputDetector の初期化処理は最低一つの入力状態の取得を保証するか
TEST(InputDetectorInitializationSuite, StateReadingTest1)
{
    for (const auto& id : nnt::hid::InputSourceIdSets)
    {
        ::nn::hid::system::InitializeInputDetector();

        // 初期化直後の入力状態の取得に成功する。
        ::nn::hid::system::GetInputSourceState(&g_State, id);

        ::nn::hid::debug::FinalizeInputDetector();
    }
}
