﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid/debug/hid_HomeButton.h>
#include <nn/hid/system/hid_HomeButton.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#include "../Common/testHid_HomeButton.h"

//!< 入力状態は 15 ms 以上の間隔を開けて追加されるか
TEST(HomeButtonPerformanceSuite, StateReadingTest1)
{
    ::nn::hid::system::InitializeHomeButton();

    ::nn::hid::system::HomeButtonState state1 = {};

    EXPECT_EQ(1, ::nn::hid::system::GetHomeButtonStates(&state1, 1));

    int64_t expectedCount = ::nn::hid::system::HomeButtonStateCountMax / 2;

    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            expectedCount *
            ::nnt::hid::GetHomeButtonSamplingInterval().GetMilliSeconds()));

    ::nn::hid::system::HomeButtonState state2 = {};

    EXPECT_EQ(1, ::nn::hid::system::GetHomeButtonStates(&state2, 1));

    int64_t observedCount = state2.samplingNumber - state1.samplingNumber + 1;

    EXPECT_LE(expectedCount - 2, observedCount);
    EXPECT_GE(expectedCount + 2, observedCount);

    ::nn::hid::debug::FinalizeHomeButton();
}
