﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/hid.h>
#include <nn/hid/debug/hid_DebugPad.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#include "../Common/testHid_DebugPad.h"

//!< 入力状態は 10 ms 以上の間隔を開けて追加されるか
TEST(DebugPadPerformanceSuite, ReadingStateTest1)
{
    ::nn::hid::InitializeDebugPad();

    ::nn::hid::DebugPadState state1 = {};

    ::nn::hid::GetDebugPadState(&state1);

    int64_t expectedCount = ::nn::hid::DebugPadStateCountMax / 2;

    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            expectedCount *
            ::nnt::hid::GetDebugPadSamplingInterval().GetMilliSeconds()));

    ::nn::hid::DebugPadState state2 = {};

    ::nn::hid::GetDebugPadState(&state2);

    int64_t observedCount = state2.samplingNumber - state1.samplingNumber + 1;

    EXPECT_LE(expectedCount - 2, observedCount);
    EXPECT_GE(expectedCount + 2, observedCount);

    ::nn::hid::debug::FinalizeDebugPad();
}
