﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid/hid_Mouse.h>
#include <nn/hid/debug/hid_Mouse.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace hid {

//!< Mouse の座標域の幅
const int MouseRectangleWidth = 1280;

//!< Mouse の座標域の高さ
const int MouseRectangleHeight = 720;

//!< Mouse のサンプリング間隔を返します。
inline ::nn::TimeSpanType GetMouseSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(8);
}

//!< Mouse を終了します。（自動操作に関する自動テスト用）
inline void FinalizeMouseForAutoPilot() NN_NOEXCEPT
{
#if !defined(NN_BUILD_CONFIG_OS_WIN)
    ::nn::hid::debug::UnsetMouseAutoPilotState();
    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            ::nn::hid::MouseStateCountMax *
            GetMouseSamplingInterval().GetMilliSeconds()));
#endif
    ::nn::hid::debug::FinalizeMouse();
}

}} // namaspace nnt::hid
