﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/hid/system/hid_InputDetection.h>

namespace nnt { namespace hid {

// テスト対象の InputSourceIdSet
const ::nn::hid::system::InputSourceIdSet InputSourceIdSets[] = {
    // 1 つづつ
    ::nn::hid::system::InputSourceId::Sensor::Mask,
    ::nn::hid::system::InputSourceId::DebugPad::Mask,
    ::nn::hid::system::InputSourceId::TouchScreen::Mask,
    ::nn::hid::system::InputSourceId::Keyboard::Mask,
    ::nn::hid::system::InputSourceId::Mouse::Mask,
    ::nn::hid::system::InputSourceId::UsbPort::Mask,
    ::nn::hid::system::InputSourceId::SdCardSlot::Mask,
    ::nn::hid::system::InputSourceId::GameCardSlot::Mask,
    ::nn::hid::system::InputSourceId::PadConnection::Mask,
    ::nn::hid::system::InputSourceId::AnalogStick::Mask,
    ::nn::hid::system::InputSourceId::ConsoleSixAxisSensor::Mask,
    // 全部入り
    (
        ::nn::hid::system::InputSourceId::Sensor::Mask                |
        ::nn::hid::system::InputSourceId::DebugPad::Mask              |
        ::nn::hid::system::InputSourceId::TouchScreen::Mask           |
        ::nn::hid::system::InputSourceId::Keyboard::Mask              |
        ::nn::hid::system::InputSourceId::Mouse::Mask                 |
        ::nn::hid::system::InputSourceId::UsbPort::Mask               |
        ::nn::hid::system::InputSourceId::SdCardSlot::Mask            |
        ::nn::hid::system::InputSourceId::GameCardSlot::Mask          |
        ::nn::hid::system::InputSourceId::PadConnection::Mask         |
        ::nn::hid::system::InputSourceId::AnalogStick::Mask           |
        ::nn::hid::system::InputSourceId::ConsoleSixAxisSensor::Mask
    )
};

}} // namespace nnt::hid
