﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/hid/debug/hid_HomeButton.h>
#include <nn/hid/system/hid_HomeButton.h>
#include <nn/os.h>
#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace hid {

//!< ホームボタンのサンプリング間隔を返します。
inline ::nn::TimeSpanType GetHomeButtonSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(15);
}

//!< ホームボタンを終了します。（自動操作に関する自動テスト用）
inline void FinalizeHomeButtonForAutoPilot() NN_NOEXCEPT
{
#if !defined(NN_BUILD_CONFIG_OS_WIN)
    ::nn::hid::debug::UnsetHomeButtonAutoPilotState();
    ::nn::os::SleepThread(
        ::nn::TimeSpan::FromMilliSeconds(
            ::nn::hid::system::HomeButtonStateCountMax *
            GetHomeButtonSamplingInterval().GetMilliSeconds()));
#endif
    ::nn::hid::debug::FinalizeHomeButton();
}

}} // namaspace nnt::hid
