﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../Shared/VideoConfigUtility.h"

namespace nnt { namespace hdcp {

class HdcpRawTestInitializer
{
private:
    nns::VideoConfigUtility* m_pVideo;
public:
    NN_IMPLICIT HdcpRawTestInitializer() NN_NOEXCEPT;
    ~HdcpRawTestInitializer() NN_NOEXCEPT;
    bool IsHdmiConnected() NN_NOEXCEPT;
    void ShowWarningBasedOnHdmiConnection(bool isConnectionExcected) NN_NOEXCEPT;
    bool StartThreadToImposeStressOnDpcd() NN_NOEXCEPT;
    void StopThreadToImposeStressOnDpcd() NN_NOEXCEPT;
    void ChangeDisplayResolution() NN_NOEXCEPT;
};

}}
