﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>
#include <nnt/nntest.h>
#include <algorithm>

#include "../Shared/testHdcp_Config.h"
#include "../Shared/testHdcp_Helper.h"
#include "../Shared/testHdcp_Util-hardware.nx.h"
#include "../Shared/HdcpTestInitializer.h"

/**
 * @brief   イベントがシグナルされるかどうか。
 */
TEST(Disconnected, EventHandler)
{
    nnt::hdcp::HdcpTestInitializer initializer;

    bool isSignaled;
    nn::hdcp::HdcpAuthenticationState state;

    // イベント登録。
    nn::os::SystemEventType eventType;
    hdcpc::GetHdcpStateTransitionEvent(&eventType);

    // HDCPを無効にする。状態遷移が起きなくなったらテストスタート。
    hdcpc::SetCurrentHdcpMode(nn::hdcp::HdcpMode_Disabled);
    while (nn::os::TimedWaitSystemEvent(&eventType, nn::TimeSpan::FromMilliSeconds(300)))
    {
        nn::os::ClearSystemEvent(&eventType);
    }
    hdcpc::GetHdcpAuthenticationState(&state);
    EXPECT_EQ(nn::hdcp::HdcpAuthenticationState_NotPlugged, state);

    // HDCPを有効にする。
    hdcpc::SetCurrentHdcpMode(nn::hdcp::HdcpMode_Enabled);

    // ディスプレイがないので認証は始まらない。
    hdcpc::GetHdcpAuthenticationState(&state);
    EXPECT_EQ(nn::hdcp::HdcpAuthenticationState_NotPlugged, state);
    // イベントは飛んでこない。
    isSignaled = nn::os::TimedWaitSystemEvent(&eventType, nn::TimeSpan::FromMilliSeconds(300));
    ASSERT_EQ(false, isSignaled);
    // ディスプレイがないので認証は始まらない。
    hdcpc::GetHdcpAuthenticationState(&state);
    EXPECT_EQ(nn::hdcp::HdcpAuthenticationState_NotPlugged, state);

    // HDCPを無効にする。
    hdcpc::SetCurrentHdcpMode(nn::hdcp::HdcpMode_Disabled);

    // ディスプレイがないので認証は始まらない。
    hdcpc::GetHdcpAuthenticationState(&state);
    EXPECT_EQ(nn::hdcp::HdcpAuthenticationState_NotPlugged, state);
    // イベントは飛んでこない。
    isSignaled = nn::os::TimedWaitSystemEvent(&eventType, nn::TimeSpan::FromMilliSeconds(300));
    ASSERT_EQ(false, isSignaled);
    // ディスプレイがないので認証は始まらない。
    hdcpc::GetHdcpAuthenticationState(&state);
    EXPECT_EQ(nn::hdcp::HdcpAuthenticationState_NotPlugged, state);
}
