﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/grc/grc_Api.h>
#include <nn/grc/grc_Application.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "testGrc_Macro.h"
#include "testGrc_MemoryManagement.h"

#define NNT_GRC_INITIALIZE_FOR_APPLICATION(aruidValue)  \
    {                                                           \
        nn::applet::AppletResourceUserId aruid = {static_cast<uint64_t>(aruidValue)};   \
        nn::sf::SharedPointer<nn::grcsrv::IMovieMaker> pMovieMakerProxy; \
        NNT_GRC_EXPECT_SUCCESS(nn::grc::CreateMovieMakerForApplication(&pMovieMakerProxy, aruid, {0x010000000000B1C1ull})); \
        NNT_GRC_EXPECT_SUCCESS(nn::grc::InitializeForApplication(std::move(pMovieMakerProxy))); \
    }

#define NNT_GRC_DEV_INITIALIZE_MOVIEMAKER_PROXY(aruidValue)  \
    {                                                           \
        nn::applet::AppletResourceUserId aruid = {static_cast<uint64_t>(aruidValue)};   \
        nn::sf::SharedPointer<nn::grcsrv::IMovieMaker> pMovieMakerProxy; \
        NNT_GRC_EXPECT_SUCCESS(nn::grc::CreateMovieMakerForApplication(&pMovieMakerProxy, aruid, {0x010000000000B1C1ull})); \
        NNT_GRC_EXPECT_SUCCESS(nn::grc::dev::InitializeMovieMakerProxy(std::move(pMovieMakerProxy))); \
    }

NNT_GRC_TEST_SERVERSTATE(Connection_Dev_Maker)
{
    const int RepeatCount = 100;

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::grc::InitializeByHipc());
    NN_UTIL_SCOPE_EXIT{ nn::grc::FinalizeByHipc(); };


    for(int i = 0; i < RepeatCount; i++)
    {
        NN_LOG("Loop %d/%d\n", i + 1, RepeatCount);
        NNT_GRC_DEV_INITIALIZE_MOVIEMAKER_PROXY(__LINE__ + i);
        nn::grc::dev::FinalizeMovieMakerProxy();
    }
}

NNT_GRC_TEST_SERVERSTATE(Connection_Dev_Video)
{
    const int RepeatCount = 100;
    InitializeGraphics();

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::grc::InitializeByHipc());
    NN_UTIL_SCOPE_EXIT{ nn::grc::FinalizeByHipc(); };

    NNT_GRC_DEV_INITIALIZE_MOVIEMAKER_PROXY(__LINE__);
    NN_UTIL_SCOPE_EXIT{ nn::grc::dev::FinalizeMovieMakerProxy(); };

    for(int i = 0; i < RepeatCount; i++)
    {
        NN_LOG("Loop %d/%d\n", i + 1, RepeatCount);
        NNT_GRC_EXPECT_SUCCESS(nn::grc::dev::InitializeMovieVideoProxy());
        nn::grc::dev::FinalizeMovieVideoProxy();
    }
}

NNT_GRC_TEST_SERVERSTATE(Connection_Dev_MakerVideo_1)
{
    const int RepeatCount = 100;
    InitializeGraphics();

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::grc::InitializeByHipc());
    NN_UTIL_SCOPE_EXIT{ nn::grc::FinalizeByHipc(); };

    for(int i = 0; i < RepeatCount; i++)
    {
        NN_LOG("Loop %d/%d\n", i + 1, RepeatCount);
        NNT_GRC_DEV_INITIALIZE_MOVIEMAKER_PROXY(__LINE__ + i);
        NNT_GRC_EXPECT_SUCCESS(nn::grc::dev::InitializeMovieVideoProxy());
        nn::grc::dev::FinalizeMovieVideoProxy();
        nn::grc::dev::FinalizeMovieMakerProxy();
    }
}

NNT_GRC_TEST_SERVERSTATE(Connection_Dev_MakerVideo_2)
{
    const int RepeatCount = 100;
    InitializeGraphics();

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::grc::InitializeByHipc());
    NN_UTIL_SCOPE_EXIT{ nn::grc::FinalizeByHipc(); };

    for(int i = 0; i < RepeatCount; i++)
    {
        NN_LOG("Loop %d/%d\n", i + 1, RepeatCount);
        NNT_GRC_DEV_INITIALIZE_MOVIEMAKER_PROXY(__LINE__ + i);
        NNT_GRC_EXPECT_SUCCESS(nn::grc::dev::InitializeMovieVideoProxy());
        nn::grc::dev::FinalizeMovieMakerProxy();
        nn::grc::dev::FinalizeMovieVideoProxy();
    }
}

NNT_GRC_TEST_SERVERSTATE(Connection_Api_InitializeFinalize)
{
    const int RepeatCount = 100;
    InitializeGraphics();

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::grc::InitializeByHipc());
    NN_UTIL_SCOPE_EXIT{ nn::grc::FinalizeByHipc(); };

    for(int i = 0; i < RepeatCount; i++)
    {
        NN_LOG("Loop %d/%d\n", i + 1, RepeatCount);
        NNT_GRC_INITIALIZE_FOR_APPLICATION(__LINE__);
        nn::grc::FinalizeForApplication();
    }
}
