@set SPEC=%1
@set PLATFORM=%2
@set OSTYPE=%3
@set TEST_PROGRAM_NAME=testUi2d_RuntimeUnitTest

::------------------------------------------------------------------------------
:: epX
::------------------------------------------------------------------------------
@set SIGLO_ROOT=%~dp0..\..\..\..\..\..\..\

:: f[^Zbgt@ĈfBNg
@set DATASET_SOURCE_DIR=%SIGLO_ROOT%Externals\TestBinaries\Ui2d\Sources\RenderAndCapture\

:: tHg̃\[Xt@ĈfBNg
@set FONT_SOURCE_DIR=%SIGLO_ROOT%Externals\TestBinaries\Ui2d\Sources\Fonts\

:: CAEg̃\[Xt@ĈfBNg
@set LAYOUT_SOURCE_DIR=%SIGLO_ROOT%Externals\TestBinaries\Ui2d\Sources\Layouts\

@set FONT_CONVERTER=%SIGLO_ROOT%Tools\Graphics\FontConverter\FontConverterConsole.exe
@set LAYOUT_CONVERTER=%SIGLO_ROOT%Tools\Graphics\LayoutTools\LayoutConverter.exe
@set LAYOUT_ARCHIVER=%SIGLO_ROOT%Tools\Graphics\LayoutTools\LayoutArchiver.exe

:: RoCiGfB^̂fBNgAyђ`fBNg
@set COMBINER_EDITOR_PATH=%SIGLO_ROOT%Externals\TestBinaries\Ui2d\OldTools\4_x_x\Tools\Graphics\CombinerEditor\CombinerEditor.exe
@set COMBINER_SHADER_ENV_DIRECTORIES=%LAYOUT_SOURCE_DIR%Ui2dDefinitions

@set RESOURCE_DIR=%SIGLO_ROOT%Tests\Outputs\%PLATFORM%\Tests\%TEST_PROGRAM_NAME%\Contents\%SPEC%\Resources\
@set FONT_CONVERTER_OPTION=-i win -in Tahoma -is 32 -ic A8 -tile-mode Linear -o bffnt
@set COMBINERUSERSHADER_OPTION=--shader-env-directories %COMBINER_SHADER_ENV_DIRECTORIES% --combiner-editor-path %COMBINER_EDITOR_PATH%
@set LAYOUT_CONVERTER_OPTION=--no-copy-font -g --degamma-texture --gpu-encoding "false"
@set LAYOUT_ARCHIVER_OPTION=--tile-mode Linear --api-type Gl --code-type Source

::------------------------------------------------------------------------------
:: \[XRo[g
::------------------------------------------------------------------------------

@if "%SPEC%"=="NX" if "%OSTYPE%"=="horizon" (
echo @ ϐݒ
@set FONT_CONVERTER_OPTION=-i win -in Tahoma -is 32 -ic A8 -tile-mode NX -o bffnt
@set LAYOUT_ARCHIVER_OPTION=--tile-mode NX --api-type Nvn --code-type Binary
) else if "%SPEC%"=="NX" if "%OSTYPE%"=="win32" (
echo NXOnWin ϐݒ
@set FONT_CONVERTER_OPTION=-i win -in Tahoma -is 32 -ic A8 -tile-mode NX -o bffnt
@set LAYOUT_ARCHIVER_OPTION=--tile-mode NX --api-type Nvn --code-type Binary_Ir
) else (
echo Generic ϐݒ
)

@if not exist %RESOURCE_DIR% (
  echo \[XfBNg쐬܂B
  mkdir %RESOURCE_DIR%
)

@if exist %RESOURCE_DIR%dataset.txt (
  echo Õf[^Zbgt@C폜܂B
  @del /Q %RESOURCE_DIR%dataset.txt >NUL 2>&1
)
echo f[^Zbgt@CRs[܂B
copy /Y %DATASET_SOURCE_DIR%dataset.txt %RESOURCE_DIR%dataset.txt >NUL 2>&1

:: tHgRo[g
@if not exist %FONT_CONVERTER% (
@set ERROR_MESSAGE=tHgRo[^܂
@goto ON_ERROR_MESSAGE
)

echo ÕtHgt@C폜܂B
del /Q %RESOURCE_DIR%*.bffnt >NUL 2>&1
echo tHg̕ϊs܂B
@for %%I in ( %FONT_SOURCE_DIR%*.xllt ) do (
@%FONT_CONVERTER% %FONT_CONVERTER_OPTION% -of %RESOURCE_DIR%%%~nI.bffnt -f %%I
@if ERRORLEVEL 1 goto ON_ERROR
)

:: CAEgRo[g
@if not exist %LAYOUT_CONVERTER% (
@set ERROR_MESSAGE=CAEgRo[^܂
@goto ON_ERROR_MESSAGE
)
@if not exist %LAYOUT_ARCHIVER% (
@set ERROR_MESSAGE=CAEgA[JCo܂
@goto ON_ERROR_MESSAGE
)
echo ÕCAEgt@C폜܂B
del /Q %RESOURCE_DIR%*.arc >NUL 2>&1
rmdir /S /Q %RESOURCE_DIR%arcsrc\ >NUL 2>&1
mkdir %RESOURCE_DIR%arcsrc\
echo CAEg̕ϊs܂B
@%LAYOUT_CONVERTER% %LAYOUT_CONVERTER_OPTION% %LAYOUT_SOURCE_DIR%layout %RESOURCE_DIR%arcsrc %COMBINERUSERSHADER_OPTION%
@if ERRORLEVEL 1 goto ON_ERROR
echo CAEg̃A[JCus܂B
@%LAYOUT_ARCHIVER% %LAYOUT_ARCHIVER_OPTION% -D %RESOURCE_DIR%arcsrc %RESOURCE_DIR%testUi2d_RuntimeUnitTest.arc .
@if ERRORLEVEL 1 goto ON_ERROR

@goto EOF

:ON_ERROR_MESSAGE
    echo ------------------------------------------------------
    echo ERROR!! %ERROR_MESSAGE%
    echo ------------------------------------------------------
    set ERRORLEVEL=1
    goto ON_ERROR

:ON_ERROR
    echo G[܂iIR[h%ERRORLEVEL%j
    pause
    goto EOF

:EOF
