﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/gfx.h>
#include <nnt/graphics/testGraphics_AllocatorFunction.h>

namespace nns
{
namespace gfx
{
class GraphicsFramework;
}
}

namespace nnt{ namespace ui2d{

    class TextureCapture
    {
    public:
        TextureCapture();
        ~TextureCapture();
        void Initialize(
            nn::gfx::Device* pDevice,
            nns::gfx::GraphicsFramework& framework,
            nnt::graphics::AllocatorFunction* pAllocatorFunction,
            int screenWidth,
            int screenHeight);
        void Finalize(nns::gfx::GraphicsFramework& framework);

        /**
         * @brief キャプチャを実行中かを返します。
         *
         * @details PushCaptureCommand() の呼び出しにより、 true を返すようになります。
         *   FetchCaptureResult() の呼び出しにより、 false を返すようになります。
         */
        bool IsCapturing() const;

        /**
         * @brief 画面のキャプチャを行うコマンドを挿入します。
         */
        void PushCaptureCommand(nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::Texture* pSrcTexture);
        /**
         * @brief キャプチャした画面を内部バッファに転送します。
         */
        void FetchCaptureResult();

        /**
         * @brief 最後にキャプチャした画像データを取得します。
         */
        const uint8_t* GetCapturedImageData() const;
        /**
         * @brief 最後にキャプチャした画像データの容量を取得します。
         */
        size_t GetCapturedImageDataSize() const;

    private:
        void* AllocateMemory(size_t size, int alignment);
        void  DeallocateMemory(void* ptr);

    private:
        bool m_IsInitialized;
        bool m_IsCapturing;

        nnt::graphics::AllocatorFunction* m_pAllocateFunction;

        int m_ScreenWidth;
        int m_ScreenHeight;

        nn::gfx::Device* m_pDevice;
        nn::gfx::Buffer m_CaptureBuffer;

        uint8_t* m_CapturedImageBuffer;
        size_t m_CapturedImageBufferSize;
        ptrdiff_t   m_BufferMemoryPoolOffset;
    };

}}
