﻿#===========================================================================
# GUI版 サンプルのビルド／実行 ツール
#
# ※このツールの起動には powershell Version 3.0 以上が必要です。
#===========================================================================
Add-Type -AssemblyName presentationframework

[xml]$loadXaml = @"
<Window xmlns="http://schemas.microsoft.com/winfx/2006/xaml/presentation"
        xmlns:x="http://schemas.microsoft.com/winfx/2006/xaml"
        Title="Ui2d テスト" Height="650" Width="625">

    <Window.Resources>
        <!-- 通常時のボタンの背景色 -->
        <SolidColorBrush x:Key="NormalBackgroundBrush64" Color="#D0DDDD"/>
        <!-- 通常時のボタンの背景色 -->
        <SolidColorBrush x:Key="NormalBackgroundBrushRef" Color="#DDDDD0"/>
        <!-- カスタムボタンのスタイル（64） -->
        <Style x:Key="ButtonStyle32" TargetType="{x:Type Button}">
            <Setter Property="Background" Value="{StaticResource NormalBackgroundBrush64}"/>
        </Style>
    </Window.Resources>

        <StackPanel Orientation="Vertical" Margin="2">
            <GroupBox Header="全体管理" Margin="2">
                <StackPanel Orientation="Vertical">
                    <StackPanel Orientation="Horizontal">
                        <Button Name="allClear" Content="クリア" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="ビルドされた出力やキャプチャ結果をクリアします。(注)git clean -fdx Programs,Tests,Tools" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                    <StackPanel Orientation="Horizontal">
                        <Button Name="allBuild" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="全てのビルドを行います。" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <!-- エスケープ文字には エンティティ参照を使う  -->
            <GroupBox Header="HostBridge IP アドレス（実機 IP アドレスが &quot;169.*&quot; 以外は必須）" Margin="2">
                <StackPanel Orientation="Vertical">
                    <TextBlock Name="TargetAddressPattern" Text="TARGET_ADDRESS_PATTERN="/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <TextBox Name="ip0" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip1" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip2" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip3" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                    <StackPanel Orientation="Horizontal">
                        <Button Name="setTargetAddressPattern" Content="設定" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="setEnvTargetAddressPattern" Content="環境変数に追加" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="resetEnvTargetAddressPattern" Content="環境変数から削除" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <GroupBox Header="RendarAndCapture 設定" Margin="2">
                <StackPanel Orientation="Vertical">
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="datasetOpen" Content="dataset.txt を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="&quot;Externals\TestBinaries\Ui2d\Sources\RenderAndCapture\dataset.txt&quot; を開きます。" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <GroupBox Header="個別管理" Margin="2">
                <StackPanel Orientation="Vertical">
                    <TextBlock Text="注意：NO_FILE で実行できない場合、もう一回ビルドします。（nact が vcxproj を削除しています）"/>
                    <TextBlock Text="NX実機ツールの作成"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="toolsBuild" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="NX(実機) を実行するには必須です。"/>
                    </StackPanel>

                    <TextBlock Text="Win64"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="win64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="win64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="win64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="win64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="win64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="NXOnWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(実機)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="NXFP2_a64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXFP2_a64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXFP2_a64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="補）正解画像には NX64(Win) が使われます"/>
                    </StackPanel>

                </StackPanel>
            </GroupBox>
        </StackPanel>
</Window>
"@

# Windows7 等は標準が Version 2.0 の為、3 に満たない場合は起動しないようにする。
if($PSVersionTable.PSVersion.Major -lt 3){
   $message = "Powershellバージョン 3 以上が必要です。" + "現在のバージョンは " + $PSVersionTable.PSVersion.Major + " です。"
   Write-Output $message
   exit
}

# 多重ビルド抑止用のロックファイルが存在する場合は、起動時に削除を行う。
if (Test-Path Build/.lock)
{
	Remove-Item Build/.lock
}

$reader = New-Object System.Xml.XmlNodeReader $loadXaml
$window = [Windows.Markup.XamlReader]::Load($reader)

#===========================================================================
# 全体管理
#===========================================================================
$allClear   = $window.Findname("allClear");
$allBuild   = $window.Findname("allBuild");

$allClear.Add_Click({
   try
   {
      Start-Process -FilePath ".\Clean.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Clean.bat が見つかりません。")
   }
})
$allBuild.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build_All.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build_All.bat が見つかりません。")
   }
})

#===========================================================================
# Tools
#===========================================================================
$toolsBuild = $window.Findname("toolsBuild");

$toolsBuild.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_Tools.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_Tools.bat が見つかりません。")
   }
})

#===========================================================================
# win64
#===========================================================================
$win64Build     = $window.Findname("win64Build");
$win64Execute   = $window.Findname("win64Execute");
$win64Result    = $window.Findname("win64Result");
$win64Capture   = $window.Findname("win64Capture");
$win64Reference = $window.Findname("win64Reference");

$win64Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build-platform.Win64.bat が見つかりません。")
   }
})
$win64Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.Win64.bat が見つかりません。")
   }
})
$win64Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result-platform.Win64.bat が見つかりません。")
   }
})
$win64Capture.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testUi2d_RenderAndCapture\x64-v140\CURRENT\AllDataCopyInstance\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testUi2d_RenderAndCapture\x64-v140\CURRENT\AllDataCopyInstance\captured が見つかりません。")
   }
})
$win64Reference.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\ReferenceImages\RenderAndCapture\Win64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\ReferenceImages\RenderAndCapture\Win64 が見つかりません。")
   }
})

#===========================================================================
# NXOnWin64
#===========================================================================
$NXOnWin64Build     = $window.Findname("NXOnWin64Build");
$NXOnWin64Execute   = $window.Findname("NXOnWin64Execute");
$NXOnWin64Result    = $window.Findname("NXOnWin64Result");
$NXOnWin64Capture   = $window.Findname("NXOnWin64Capture");
$NXOnWin64Reference = $window.Findname("NXOnWin64Reference");

$NXOnWin64Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build-platform.NXOnWin64.bat が見つかりません。")
   }
})
$NXOnWin64Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.NXOnWin64.bat が見つかりません。")
   }
})
$NXOnWin64Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result-platform.NXOnWin64.bat が見つかりません。")
   }
})
$NXOnWin64Capture.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testUi2d_RenderAndCapture\NX-x64-v140\CURRENT\AllDataCopyInstance\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testUi2d_RenderAndCapture\NX-x64-v140\CURRENT\AllDataCopyInstance\captured が見つかりません。")
   }
})
$NXOnWin64Reference.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\ReferenceImages\RenderAndCapture\NXOnWin64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\ReferenceImages\RenderAndCapture\NXOnWin64 が見つかりません。")
   }
})

#===========================================================================
# NXFP2-a64
#===========================================================================
$NXFP2_a64Build     = $window.Findname("NXFP2_a64Build");
$NXFP2_a64Execute   = $window.Findname("NXFP2_a64Execute");
$NXFP2_a64Result    = $window.Findname("NXFP2_a64Result");

$NXFP2_a64Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build-platform.NXFP2-a64.bat が見つかりません。")
   }
})
$NXFP2_a64Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.NXFP2-a64.bat が見つかりません。")
   }
})
$NXFP2_a64Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result-platform.NXFP2-a64.bat が見つかりません。")
   }
})

#===========================================================================
# TARGET_ADDRESS_PATTERN
#===========================================================================
$ip0        = $window.Findname("ip0");
$ip1        = $window.Findname("ip1");
$ip2        = $window.Findname("ip2");
$ip3        = $window.Findname("ip3");
$ta         = $window.Findname("TargetAddressPattern");
$setTa      = $window.Findname("setTargetAddressPattern");
$setEnvTa   = $window.Findname("setEnvTargetAddressPattern");
$resetEnvTa = $window.Findname("resetEnvTargetAddressPattern");

if (($env:TARGET_ADDRESS_PATTERN).Length -eq 0)
{
#   "undefined TARGET_ADDRESS_PATTERN"
}
else
{
   $targetAddressPattern = ($env:TARGET_ADDRESS_PATTERN);

   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $targetAddressPattern;

   $ip = $targetAddressPattern.Split(".");
   $ip0.Text = $ip[0]
   $ip1.Text = $ip[1]
   $ip2.Text = $ip[2]
   $ip3.Text = $ip[3]
}

$setTa.Add_Click({
   $ip = $ip0.Text + "." + $ip1.Text + "." + $ip2.Text + "." + $ip3.Text;
   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $ip;

   set-item env:TARGET_ADDRESS_PATTERN -value $ip

# 永続的に環境変数を設定する場合
#   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $ip, [EnvironmentVariableTarget]::User)

})
$setEnvTa.Add_Click({
   $ip = $ip0.Text + "." + $ip1.Text + "." + $ip2.Text + "." + $ip3.Text;
   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $ip;

   set-item env:TARGET_ADDRESS_PATTERN -value $ip

   # 永続的に環境変数を設定する
   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $ip, [EnvironmentVariableTarget]::User)
})
$resetEnvTa.Add_Click({
   $ta.Text = "TARGET_ADDRESS_PATTERN="

   set-item env:TARGET_ADDRESS_PATTERN -value ""

   # 永続的に環境変数を設定する
   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $null, [EnvironmentVariableTarget]::User)
})

#===========================================================================
# TARGET_ADDRESS_PATTERN
#===========================================================================
$datasetOpen = $window.Findname("datasetOpen");

$datasetOpen.Add_Click({

   $result = (Test-Path "..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\Sources\RenderAndCapture\dataset.txt")
   if($result)
   {
      notepad ..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\Sources\RenderAndCapture\dataset.txt
   }
   else
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Ui2d\Sources\RenderAndCapture\dataset.txt が見つかりません。")
   }
})

$result = $window.ShowDialog()
