﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>

namespace nnt{ namespace ui2d{

    enum RunMode
    {
        RunMode_CompareRenderedImage,
        RunMode_CreateReferenceImage,
        RunMode_Max,
    };

    class Dataset
    {
    public:
        struct Config{
            RunMode runMode;
            bool isAssertionEnabled;
        };
        struct Data
        {
            char* beginData;
            char* endData;
            char* beginDataName;
            char* endDataName;
            char* beginLayoutName;
            char* endLayoutName;
            char* beginAnimatorTag;
            char* endAnimatorTag;
            char* beginKeyFrames;
            char* endKeyFrames;
            char* fonts;
            char* fcpxs;
            int drawCount;
            int nextKeyFrame;
        };
    public:
        Dataset();
        ~Dataset();
        void Initialize(const char* filename);
        void Finalize();

        void ReadConfig();
        bool NextData();
        bool NextKeyFrame();

        void ForEachFont(void (*func)(const char* fontName, void* param), void* param);
        void ForEachFcpx(void (*func)(const char* fcpxName, void* param), void* param);

        bool IsAnimationData() const;
        const char* GetDataName() const;
        const char* GetLayoutName() const;
        const char* GetAnimatorTag() const;
        int GetDrawCount() const;
        int GetKeyFrame() const;

        RunMode GetRunMode() const;
        bool GetIsAssertionEnabled() const;

    private:
        char* m_FileBuffer;
        char* m_PosFile;
        char* m_EndFile;
        char* m_FontNameBuffer;
        size_t m_FontNameBufferSize;
        char* m_FcpxNameBuffer;
        size_t m_FcpxNameBufferSize;

        Config m_Config;
        Data m_Data;
    };



}}
