﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "icosphere.h"

namespace Icosphere
{
    int vertexForEdge(Lookup& lookup, VertexList& vertices, int first, int second)
    {
        Lookup::key_type key(first, second);
        if (key.first > key.second)
        {
            std::swap(key.first, key.second);
        }

        auto inserted = lookup.insert({ key, static_cast<int>(vertices.size()) });
        if (inserted.second)
        {
            nn::util::Vector3fType& edge0 = vertices[first];
            nn::util::Vector3fType& edge1 = vertices[second];
            nn::util::Vector3fType tot;
            nn::util::VectorAdd(&tot, edge0, edge1);
            nn::util::Vector3fType n;
            nn::util::VectorNormalize(&n, tot);
            vertices.push_back(n);
        }

        return inserted.first->second;
    }

    void makeIcosphere(int subdivisions, IndexedMesh* mesh)
    {
        mesh->first = initialVertexList;
        mesh->second = initialTriangleList;
        TriangleList list1 = initialTriangleList;
        TriangleList list2;

        list1.reserve(25000000);
        list2.reserve(25000000);

        TriangleList* pCurrTriangles = &list1;
        TriangleList* pResTriangles = &list2;
        bool first = true;

        Lookup lookup;
        for (int i = 0; i < subdivisions; ++i)
        {
            //TriangleList result;
            pResTriangles->clear();
            lookup.clear();

            VertexList& vertices = mesh->first;
            //TriangleList& triangles = mesh->second;

            for (auto&& each : *pCurrTriangles)
            {
                int mid[3];
                for (int edge = 0; edge < 3; ++edge)
                {
                    mid[edge] = vertexForEdge(lookup, vertices, each.vertex[edge], each.vertex[(edge + 1) % 3]);
                }

                pResTriangles->push_back({{ each.vertex[0], mid[0], mid[2] }});
                pResTriangles->push_back({{ each.vertex[1], mid[1], mid[0] }});
                pResTriangles->push_back({{ each.vertex[2], mid[2], mid[1] }});
                pResTriangles->push_back({{ mid[0], mid[1], mid[2] }});
            }
            if(first)
            {
                pCurrTriangles = &list2;
                pResTriangles = &list1;
                first = false;
            }
            else
            {
                pCurrTriangles = &list1;
                pResTriangles = &list2;
                first = true;
            }
        }
        mesh->second = *pCurrTriangles;
    }
}
