:: --------------------------------------------------------------------------------*
::  Copyright (C)Nintendo All rights reserved.
::
::  These coded instructions, statements, and computer programs contain proprietary
::  information of Nintendo and/or its licensed developers and are protected by
::  national and international copyright laws. They may not be disclosed to third
::  parties or copied or duplicated in any form, in whole or in part, without the
::  prior written consent of Nintendo.
::
::  The content herein is highly confidential and should be handled accordingly.
:: --------------------------------------------------------------------------------*/

REM
REM postbuild.bat: build the resources for the application
REM
REM parameters:
REM %1 == SDK Root Directory
REM %2 == Project Output Directory

set RootDir=%1
set OutDir=%2
set Assets=%RootDir%\Externals\TestBinaries\Gfx\Resources\Nvngd_tests
set Tools=%RootDir%\Tests\Resources

if not exist "%Tools%\nvngdSupport\" (
  mkdir "%Tools%\nvngdSupport\"
)

copy /Y "%OutDir%\testNvngd_NvnTutorial02.exe" "%Tools%\nvngdSupport\"
if not %ERRORLEVEL% == 0 goto ERROR
robocopy "%RootDir%\Tools\Graphics\NvnTools" "%Tools%\nvngdSupport" "*.dll"
if "%ERRORLEVEL%" geq "8" goto ERROR
robocopy "%RootDir%\Tools\Graphics\NvnTools" "%OutDir%\" "*.dll"
if "%ERRORLEVEL%" geq "8" goto ERROR

:SUCCESS
exit 0

:ERROR
exit %ERRORLEVEL%