﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{Texpkg_Helper.h,PageSampleNvnTutorial02}
 *
 * @brief
 *  This file defines some global texpkg objects
 *  needed to load the texture files and perform
 *  the data conversion.
 */

#pragma once

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#include <nvnTool/texpkg/nvnTool_ImageDll.h>
#include <nvnTool/texpkg/nvnTool_TexpkgDll.h>

extern nvnTool::texpkg::RawImageLib g_NvnImageLib;
extern nvnTool::texpkg::RawImageFormatManager* g_ImageLoader;
extern nvnTool::texpkg::RawImageHardwareTextureExporter* g_HwTextureExporter;

bool TexpkgHelperLoadLibraries(const wchar_t* imageDLLFile, const wchar_t* texpkgDLLFile);
