﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{UniformBuffer.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a helper class for setting up uniform
 *  blocks. This class sets up the NVNbuffer object for the
 *  block and provides methods for setting the buffers data
 *  and getting information about it.
 */

#pragma once

#include <nvn/nvn.h>
#include <cstdint>
#include "MemoryPool.h"

class UniformBuffer
{
    public:
        UniformBuffer();
        ~UniformBuffer();

        void Init(NVNdevice* pDevice, size_t bufferSize, MemoryPool* pMemoryPool);
        void Finalize();

        void SetData(const void* pData, size_t dataSize);
        void SetDataOffset(const void* pData, size_t dataSize, uint32_t offset);
        NVNbufferAddress GetBufferAddress() const;
        size_t GetSizeOfBuffer() const;

    private:
        NVNdevice*          m_pDevice;
        size_t              m_BufferSize;
        NVNbuffer           m_Buffer;
        void*               m_pMappedBuffer;
        NVNbufferAddress    m_BufferAddress;
};
