﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{TutorialUtil.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines the interface for utility functions used in
 *  the tutorials.
 */

#pragma once

#include <cstdlib>
#include <cstdint>
#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nvn/nvn.h>

NVNshaderStageBits ConvertNVNStageToBitField(NVNshaderStage stage);

size_t Align(size_t size, size_t alignment);

void* AlignedAllocate(size_t size, size_t align);

void AlignedDeallocate(void* ptr);
