﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/image/image_JpegDecoder.h>
#include <nn/nn_Assert.h>

#include <cstddef>
#include <cstdlib>

int JpegDecodeBitmap (
    const void* inputBuffer, size_t inputBufferSizeInBytes,
    void* outputBuffer, size_t outputBufferSizeInBytes,
    int* pWidth, int* pHeight, ptrdiff_t* pStrideInBytes)
{
    nn::image::JpegDecoder decoder;
    nn::image::JpegStatus status;

    decoder.SetImageData(inputBuffer, inputBufferSizeInBytes);
    decoder.SetPixelFormat(nn::image::PixelFormat_Rgb24);

    status = decoder.Analyze();
    NN_ASSERT(status == nn::image::JpegStatus_Ok);

    nn::image::Dimension dim = decoder.GetAnalyzedDimension();

    size_t requiredWorkBufferSize = decoder.GetAnalyzedWorkBufferSize();
    void* workBuffer = malloc(requiredWorkBufferSize);
    NN_ASSERT(workBuffer != NULL);

    status = decoder.Decode(outputBuffer, outputBufferSizeInBytes, 1, workBuffer, requiredWorkBufferSize);
    NN_ASSERT(status == nn::image::JpegStatus_Ok);

    uint8_t* pSwapBuffer = static_cast<uint8_t*>(outputBuffer);
    for (int i = 0; i < (dim.width * dim.height); ++i)
    {
        unsigned int temp = pSwapBuffer[0];
        pSwapBuffer[0] = pSwapBuffer[2];
        pSwapBuffer[2] = static_cast<uint8_t>(temp);

        pSwapBuffer += 3;
    }

    *pWidth = dim.width;
    *pHeight = dim.height;
    *pStrideInBytes = static_cast<ptrdiff_t>(dim.width * 3);

    free(workBuffer);

    return 0;
}
